/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdempotencyPropertiesBuilder
implements ElementPropertiesBuilder {
    private static final Logger log = LoggerFactory.getLogger(IdempotencyPropertiesBuilder.class);
    private static final Integer DEFAULT_KEY_EXPIRY = 600;
    private static final String ENABLED_PROPERTY = "enabled";

    public boolean applicableTo(ChainElement element) {
        String type = element.getType();
        return "http-trigger".equals(type) || "rabbitmq-trigger-2".equals(type) || "kafka-trigger-2".equals(type) || "async-api-trigger".equals(type) || "jms-trigger".equals(type);
    }

    public Map<String, String> build(ChainElement element) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Object idempotencyProperty = element.getProperty("idempotency");
        if (Objects.isNull(idempotencyProperty)) {
            properties.put("idempotencyEnabled", Boolean.toString(false));
        } else if (idempotencyProperty instanceof Map) {
            Map idempotencyParameters = (Map)idempotencyProperty;
            Boolean enabled = Optional.ofNullable(idempotencyParameters.get(ENABLED_PROPERTY)).orElse(Boolean.FALSE);
            properties.put("idempotencyEnabled", ((Object)enabled).toString());
            boolean isEnabled = Boolean.parseBoolean(((Object)enabled).toString());
            if (isEnabled) {
                Integer expiry = Optional.ofNullable(idempotencyParameters.get("keyExpiry")).orElse(DEFAULT_KEY_EXPIRY);
                properties.put("expiry", ((Object)expiry).toString());
            }
        } else {
            throw new SnapshotCreationException("Malformed idempotency property");
        }
        return properties;
    }
}

