/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.DeploymentProcessingException;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilder;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders.KafkaElementPropertiesBuilder;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders.RabbitMqElementPropertiesBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class OperationElementPropertiesBuilder
implements ElementPropertiesBuilder {
    private final KafkaElementPropertiesBuilder kafkaElementPropertiesBuilder;
    private final RabbitMqElementPropertiesBuilder rabbitMqElementPropertiesBuilder;

    @Autowired
    public OperationElementPropertiesBuilder(KafkaElementPropertiesBuilder kafkaElementPropertiesBuilder, RabbitMqElementPropertiesBuilder rabbitMqElementPropertiesBuilder) {
        this.kafkaElementPropertiesBuilder = kafkaElementPropertiesBuilder;
        this.rabbitMqElementPropertiesBuilder = rabbitMqElementPropertiesBuilder;
    }

    public boolean applicableTo(ChainElement element) {
        String type = element.getType();
        return "async-api-trigger".equals(type) || "service-call".equals(type);
    }

    public Map<String, String> build(ChainElement element) {
        return Optional.ofNullable(element.getEnvironment()).map(environment -> this.buildProperties(element, environment)).orElse(Collections.emptyMap());
    }

    private Map<String, String> buildProperties(ChainElement element, ServiceEnvironment environment) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(OperationElementPropertiesBuilder.buildCommonProperties((ChainElement)element));
        properties.putAll(this.buildProtocolSpecificProperties(element, environment));
        return properties;
    }

    private Map<String, String> buildProtocolSpecificProperties(ChainElement element, ServiceEnvironment environment) {
        Object protocolType = element.getProperty("integrationOperationProtocolType");
        if ("kafka".equals(protocolType)) {
            Map elementProperties = Optional.ofNullable(environment.getProperties()).map(environmentProperties -> this.kafkaElementPropertiesBuilder.buildKafkaConnectionProperties(element.getPropertyAsString("integrationOperationPath"), environment.getAddress(), (String)environmentProperties.get("securityProtocol"), (String)environmentProperties.get("saslMechanism"), (String)environmentProperties.get("saslJaasConfig"), environment.getSourceType() != null ? String.valueOf(environment.getSourceType()) : null)).orElseThrow(() -> OperationElementPropertiesBuilder.getEnvironmentNotFoundException((ChainElement)element));
            this.kafkaElementPropertiesBuilder.enrichWithAdditionalProperties(element, elementProperties);
            return elementProperties;
        }
        if ("amqp".equals(protocolType)) {
            Map elementProperties = Optional.ofNullable(environment.getProperties()).map(environmentProperties -> this.rabbitMqElementPropertiesBuilder.buildAmqpConnectionProperties((String)environmentProperties.get("sslProtocol"), environment.getAddress(), OperationElementPropertiesBuilder.getQueueName((ChainElement)element, (String)((String)environmentProperties.get("queues"))), element.getPropertyAsString("integrationOperationPath"), (String)environmentProperties.get("username"), (String)environmentProperties.get("password"), environment.getSourceType() != null ? String.valueOf(environment.getSourceType()) : null, (String)environmentProperties.get("vhost"))).orElseThrow(() -> OperationElementPropertiesBuilder.getEnvironmentNotFoundException((ChainElement)element));
            this.rabbitMqElementPropertiesBuilder.enrichWithAdditionalProperties(element, elementProperties);
            return elementProperties;
        }
        if ("grpc".equals(protocolType)) {
            return OperationElementPropertiesBuilder.buildGrpcProperties((ChainElement)element);
        }
        return Collections.emptyMap();
    }

    private static String getQueueName(ChainElement element, String queueNameFromEnv) {
        Map prop;
        if (element.getProperties() != null && element.getProperties().containsKey("integrationOperationAsyncProperties") && (prop = (Map)element.getProperties().get("integrationOperationAsyncProperties")) != null && prop.containsKey("queues")) {
            String queueName = (String)prop.get("queues");
            return StringUtils.isNotEmpty((CharSequence)queueName) ? queueName : queueNameFromEnv;
        }
        return queueNameFromEnv;
    }

    private static Map<String, String> buildCommonProperties(ChainElement element) {
        return Map.of("integrationOperationProtocolType", String.valueOf(element.getProperty("integrationOperationProtocolType")));
    }

    private static Map<String, String> buildGrpcProperties(ChainElement element) {
        return Map.of("integrationSpecificationId", element.getPropertyAsString("integrationSpecificationId"));
    }

    private static RuntimeException getEnvironmentNotFoundException(ChainElement element) {
        String message = String.format("Can't find active environment for element %s, %s", element.getName(), element.getId());
        return new DeploymentProcessingException(message);
    }
}

