/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.consul.ConsulService;
import org.qubership.integration.platform.catalog.consul.exception.KVNotFoundException;
import org.qubership.integration.platform.catalog.model.chain.SessionsLoggingLevel;
import org.qubership.integration.platform.catalog.model.deployment.properties.DeploymentRuntimeProperties;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationImplementationType;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationEntityType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin.BuiltinValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExcessiveLoggingValidation
extends BuiltinValidation {
    private static final Logger log = LoggerFactory.getLogger(ExcessiveLoggingValidation.class);
    public static final String CHAIN_SESSIONS_LOGGING_LEVEL_KEY = "chainSessionsLoggingLevel";
    private final ChainService chainService;
    private final ConsulService consulService;

    @Autowired
    public ExcessiveLoggingValidation(ChainService chainService, ConsulService consulService) {
        super("excessive-logging_I8P3SG4G", "Deployment has excessive logging settings", "Rule allows to detect chains, deployed with \"Debug\" session level of logging.", "Utilizing the \"Debug\" logging level might lead to issues with log storage space or drastically degrade performance. It is recommended to reduce the level of logging and use \"Debug\" mode only on test environments.", ValidationEntityType.CHAIN, ValidationImplementationType.BUILT_IN, ValidationSeverity.WARNING);
        this.chainService = chainService;
        this.consulService = consulService;
        this.putProperty(CHAIN_SESSIONS_LOGGING_LEVEL_KEY, (Serializable)((Object)Set.of(SessionsLoggingLevel.DEBUG.name())));
    }

    public Collection<ValidationChainAlert> validate() throws DiagnosticValidationUnexpectedException {
        try {
            return this.processValidation();
        }
        catch (KVNotFoundException kvnfe) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new DiagnosticValidationUnexpectedException("Validation failed with an unexpected error: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private Collection<ValidationChainAlert> processValidation() {
        Map runtimeConfigs = this.consulService.getChainRuntimeConfig();
        ArrayList<ValidationChainAlert> result = new ArrayList<ValidationChainAlert>();
        for (Map.Entry entry : runtimeConfigs.entrySet()) {
            Chain chain;
            DeploymentRuntimeProperties props = (DeploymentRuntimeProperties)entry.getValue();
            if (!((Set)this.getProperty(CHAIN_SESSIONS_LOGGING_LEVEL_KEY)).contains(props.getSessionsLoggingLevel().name()) || (chain = (Chain)this.chainService.tryFindById((String)entry.getKey()).orElse(null)) == null) continue;
            ValidationChainAlert alert = ValidationChainAlert.builder().validationId(this.getId()).chain(chain).build();
            alert.addProperty("sessionsLoggingLevel", (Object)props.getSessionsLoggingLevel().name());
            result.add(alert);
        }
        return result;
    }
}

