/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.persistence.configs.repository.diagnostic.ChainValidationRepository;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationImplementationType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationEntityType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin.BuiltinValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LargeSnapshotsNumberValidation
extends BuiltinValidation {
    private static final Logger log = LoggerFactory.getLogger(LargeSnapshotsNumberValidation.class);
    private static final String SNAPSHOT_WARN_COUNT_THRESHOLD_KEY = "snapshotWarnCountThreshold";
    private static final String SNAPSHOT_OLDER_THAN_DAYS_THRESHOLD_KEY = "snapshotOlderThanDaysThreshold";
    private final ChainValidationRepository chainRepository;

    public LargeSnapshotsNumberValidation(ChainValidationRepository chainRepository) {
        super("large-snapshot-number_P860TWJZ", "Large number of snapshots", "Rule allows to check the number of snapshots that older than configured value.", "Large number of snapshots might cause space consumption issues. Delete old and unused snapshots and only keep actual ones.", ValidationEntityType.CHAIN, ValidationImplementationType.BUILT_IN, ValidationSeverity.WARNING);
        this.chainRepository = chainRepository;
        this.putProperty(SNAPSHOT_OLDER_THAN_DAYS_THRESHOLD_KEY, (Serializable)((Object)"7 days"));
        this.putProperty(SNAPSHOT_WARN_COUNT_THRESHOLD_KEY, (Serializable)Integer.valueOf(50));
    }

    public Collection<ValidationChainAlert> validate() throws DiagnosticValidationUnexpectedException {
        try {
            return this.processValidation();
        }
        catch (Exception e) {
            throw new DiagnosticValidationUnexpectedException("Validation failed with an unexpected error: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private List<ValidationChainAlert> processValidation() {
        List chainIdsAndSnapshotsCount = this.chainRepository.findAllForLargeSnapshotsNumberValidation((String)this.getProperty(SNAPSHOT_OLDER_THAN_DAYS_THRESHOLD_KEY), (Integer)this.getProperty(SNAPSHOT_WARN_COUNT_THRESHOLD_KEY));
        ArrayList<ValidationChainAlert> validationAlerts = new ArrayList<ValidationChainAlert>();
        for (String[] entity : chainIdsAndSnapshotsCount) {
            String chainId = entity[0];
            String snapshotsCount = entity[1];
            Optional chainOptional = this.chainRepository.findById((Object)chainId);
            if (!chainOptional.isPresent()) continue;
            ValidationChainAlert alert = ValidationChainAlert.builder().validationId(this.getId()).chain((Chain)chainOptional.get()).build();
            alert.addProperty("issuesCount", (Object)snapshotsCount);
            validationAlerts.add(alert);
        }
        return validationAlerts;
    }
}

