/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationImplementationType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationEntityType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin.BuiltinValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UnsupportedElementUsageValidation
extends BuiltinValidation {
    private static final Logger log = LoggerFactory.getLogger(UnsupportedElementUsageValidation.class);
    private final ElementRepository elementRepository;

    public UnsupportedElementUsageValidation(ElementRepository elementRepository) {
        super("unsupported-element-usage_9HTTGFAK", "Unsupported elements found in the chain", "Rule allows to find chains with unsupported elements.", "Chain contains elements, not supported by the system anymore. Such elements must be removed or replaced before the deployment.", ValidationEntityType.CHAIN_ELEMENT, ValidationImplementationType.BUILT_IN, ValidationSeverity.ERROR);
        this.elementRepository = elementRepository;
    }

    public Collection<ValidationChainAlert> validate() throws DiagnosticValidationUnexpectedException {
        try {
            return this.processValidation();
        }
        catch (Exception e) {
            throw new DiagnosticValidationUnexpectedException("Validation failed with an unexpected error: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private List<ValidationChainAlert> processValidation() {
        List containsScriptElements = this.elementRepository.findAllByTypeInAndChainNotNull(Set.of("unsupported"));
        return containsScriptElements.stream().map(element -> ValidationChainAlert.builder().validationId(this.getId()).chain(element.getChain()).element(element).build()).toList();
    }
}

