/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.deserializer;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ServiceImportException;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.ImportFileMigration;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.ImportFileMigrationUtils;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.system.ServiceImportFileMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ServiceDeserializer {
    private static final Logger log = LoggerFactory.getLogger(ServiceDeserializer.class);
    private final YAMLMapper yamlMapper;
    private final Map<Integer, ServiceImportFileMigration> importFileMigrations;

    @Autowired
    public ServiceDeserializer(YAMLMapper yamlExportImportMapper, List<ServiceImportFileMigration> importFileMigrations) {
        this.yamlMapper = yamlExportImportMapper;
        this.importFileMigrations = importFileMigrations.stream().collect(Collectors.toMap(ImportFileMigration::getVersion, Function.identity()));
    }

    public IntegrationSystem deserializeSystem(ObjectNode serviceNode, File serviceDirectory) {
        IntegrationSystem system;
        serviceNode = this.enrichServiceNode(serviceNode, serviceDirectory);
        try {
            serviceNode = this.migrateToActualFileVersion(serviceNode);
            system = (IntegrationSystem)this.yamlMapper.treeToValue((TreeNode)serviceNode, IntegrationSystem.class);
            system.getSpecificationGroups().forEach(specificationGroup -> {
                specificationGroup.setSystem(system);
                specificationGroup.getSystemModels().forEach(systemModel -> systemModel.setSpecificationGroup(specificationGroup));
            });
        }
        catch (ServiceImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return system;
    }

    private ObjectNode enrichServiceNode(ObjectNode serviceNode, File serviceDirectory) {
        Path serviceDirectoryPath = serviceDirectory.toPath();
        String serviceId = serviceNode.get("id").asText();
        try (Stream<Path> fs = Files.walk(serviceDirectory.toPath(), new FileVisitOption[0]);){
            List<File> listOfFile = fs.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).toList();
            ArrayList<JsonNode> specificationGroupNodes = new ArrayList<JsonNode>();
            HashMap<String, List> specificationNodesMap = new HashMap<String, List>();
            HashMap<String, List> sourceFiles = new HashMap<String, List>();
            Object ddlScriptFile = null;
            for (File file : listOfFile) {
                String fileName = file.getName();
                String parentDirName = Optional.ofNullable(file.getParentFile()).map(File::toPath).map(serviceDirectoryPath::relativize).map(Path::toString).orElse("");
                if (fileName.startsWith("specGroup-")) {
                    JsonNode specGroupNode = this.yamlMapper.readTree(file);
                    String specGroupParentId = specGroupNode.get("parentId").asText();
                    if (!serviceId.equals(specGroupParentId)) continue;
                    specificationGroupNodes.add(specGroupNode);
                    continue;
                }
                if (fileName.startsWith("specification-")) {
                    JsonNode specNode = this.yamlMapper.readTree(file);
                    String specGroupId = specNode.get("parentId").asText();
                    specificationNodesMap.computeIfAbsent(specGroupId, k -> new ArrayList()).add(specNode);
                    continue;
                }
                if (!parentDirName.startsWith("source-")) continue;
                sourceFiles.computeIfAbsent(parentDirName, k -> new ArrayList()).add(file);
            }
            this.setSpecifications(serviceNode, specificationGroupNodes, specificationNodesMap);
            this.setSpecificationSources(serviceNode, sourceFiles);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error while service enriching", e);
        }
        return serviceNode;
    }

    private void setSpecifications(ObjectNode serviceNode, ArrayList<JsonNode> specificationGroupNodes, Map<String, List<JsonNode>> specificationNodesMap) {
        ArrayNode specificationGroupServiceArrayNode = ServiceDeserializer.getSpecificationGroupServiceArrayNode((ObjectNode)serviceNode);
        for (JsonNode specGroupNode : specificationGroupNodes) {
            ObjectNode specGroupObjNode = (ObjectNode)specGroupNode;
            List<JsonNode> specificationNodes = specificationNodesMap.get(specGroupNode.get("id").asText());
            if (specificationNodes == null) continue;
            specGroupObjNode.putArray("systemModels").addAll(specificationNodes);
            specificationGroupServiceArrayNode.add((JsonNode)specGroupObjNode);
        }
    }

    private static ArrayNode getSpecificationGroupServiceArrayNode(ObjectNode serviceNode) {
        ArrayNode specificationGroupServiceArrayNode = (ArrayNode)serviceNode.get("specificationGroups");
        if (specificationGroupServiceArrayNode == null) {
            specificationGroupServiceArrayNode = serviceNode.putArray("specificationGroups");
        }
        return specificationGroupServiceArrayNode;
    }

    private void setSpecificationSources(ObjectNode serviceNode, Map<String, List<File>> sourceFiles) throws IOException {
        ArrayNode specificationGroupServiceArrayNode = ServiceDeserializer.getSpecificationGroupServiceArrayNode((ObjectNode)serviceNode);
        for (JsonNode specificationGroup : specificationGroupServiceArrayNode) {
            ArrayNode specificationsArrayNode = (ArrayNode)specificationGroup.get("systemModels");
            if (specificationsArrayNode == null) continue;
            for (JsonNode specification : specificationsArrayNode) {
                ArrayNode specificationSourcesArrayNode = (ArrayNode)specification.get("specificationSources");
                if (specificationSourcesArrayNode == null) continue;
                for (JsonNode specificationSource : specificationSourcesArrayNode) {
                    String fileName;
                    String parentDir;
                    ObjectNode specificationSourceObjectNode = (ObjectNode)specificationSource;
                    String sourceFullPath = ExportImportUtils.getNodeAsText((JsonNode)specificationSource.get("fileName"));
                    if (!StringUtils.isBlank((CharSequence)sourceFullPath)) {
                        Path sourceFilePath = Paths.get(sourceFullPath, new String[0]);
                        parentDir = sourceFilePath.getParent().toString();
                        fileName = sourceFilePath.getFileName().toString();
                    } else {
                        OperationProtocol protocol = (OperationProtocol)this.yamlMapper.treeToValue((TreeNode)serviceNode.get("protocol"), OperationProtocol.class);
                        fileName = ExportImportUtils.getSpecificationFileName((JsonNode)specificationSource, (OperationProtocol)protocol);
                        parentDir = ExportImportUtils.generateDeprecatedSourceExportDir((JsonNode)specificationGroup, (JsonNode)specification);
                    }
                    String finalFileName = fileName;
                    Optional<File> sourceFile = sourceFiles.computeIfAbsent(parentDir, k -> Collections.emptyList()).stream().filter(f -> f.getName().equals(finalFileName)).findAny();
                    if (!sourceFile.isPresent()) continue;
                    specificationSourceObjectNode.put("source", ExportImportUtils.getFileContent((File)sourceFile.get()));
                }
            }
        }
    }

    private ObjectNode migrateToActualFileVersion(ObjectNode serviceNode) throws Exception {
        if (!serviceNode.has("fileVersion") && !serviceNode.has("migrations") || serviceNode.has("fileVersion") && serviceNode.get("fileVersion") != null && serviceNode.has("migrations") && serviceNode.get("migrations") != null) {
            log.error("Incorrect combination of \"{}\" and \"{}\" fields for a service migration data", (Object)"fileVersion", (Object)"migrations");
            throw new Exception("Incorrect combination of fields for a service migration data");
        }
        List<Object> importVersions = serviceNode.has("fileVersion") ? IntStream.rangeClosed(1, serviceNode.get("fileVersion").asInt()).boxed().toList() : (serviceNode.get("migrations") != null ? Arrays.stream(serviceNode.get("migrations").asText().replaceAll("[\\[\\]]", "").split(",")).map(String::trim).filter(StringUtils::isNotEmpty).map(Integer::parseInt).toList() : new ArrayList());
        log.trace("importVersions = {}", importVersions);
        List actualVersions = ImportFileMigrationUtils.getActualServiceFileMigrationVersions();
        log.trace("actualVersions = {}", (Object)actualVersions);
        ArrayList nonexistentVersions = new ArrayList(importVersions);
        nonexistentVersions.removeAll(actualVersions);
        if (!nonexistentVersions.isEmpty()) {
            String serviceId = Optional.ofNullable(serviceNode.get("id")).map(JsonNode::asText).orElse(null);
            String serviceName = Optional.ofNullable(serviceNode.get("name")).map(JsonNode::asText).orElse(null);
            log.error("Unable to import the service {} ({}) exported from newer version: nonexistent migrations {} are present", new Object[]{serviceName, serviceId, nonexistentVersions});
            throw new ServiceImportException(serviceId, serviceName, "Unable to import a service exported from newer version");
        }
        ArrayList versionsToMigrate = new ArrayList(actualVersions);
        versionsToMigrate.removeAll(importVersions);
        versionsToMigrate.sort(null);
        log.trace("versionsToMigrate = {}", versionsToMigrate);
        Iterator iterator = versionsToMigrate.iterator();
        while (iterator.hasNext()) {
            int version = (Integer)iterator.next();
            serviceNode = ((ServiceImportFileMigration)this.importFileMigrations.get(version)).makeMigration(serviceNode);
        }
        return serviceNode;
    }
}

