/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.serializer;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedIntegrationSystem;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSpecification;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSpecificationGroup;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSpecificationSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExportableObjectWriterVisitor {
    private static final Logger log = LoggerFactory.getLogger(ExportableObjectWriterVisitor.class);
    private final YAMLMapper yamlMapper;

    @Autowired
    public ExportableObjectWriterVisitor(YAMLMapper yamlExportImportMapper) {
        this.yamlMapper = yamlExportImportMapper;
    }

    public void visit(ExportedIntegrationSystem exportedIntegrationSystem, ZipOutputStream zipOut, String entryPath) throws IOException {
        ExportImportUtils.writeSystemObject((ZipOutputStream)zipOut, (String)(entryPath + ExportImportUtils.generateMainSystemFileExportName((String)exportedIntegrationSystem.getId())), (String)this.yamlMapper.writeValueAsString((Object)exportedIntegrationSystem.getObjectNode()));
    }

    public void visit(ExportedSpecificationGroup exportedSpecificationGroup, ZipOutputStream zipOut, String entryPath) throws IOException {
        ExportImportUtils.writeSystemObject((ZipOutputStream)zipOut, (String)(entryPath + ExportImportUtils.generateSpecificationGroupFileExportName((String)exportedSpecificationGroup.getId())), (String)this.yamlMapper.writeValueAsString((Object)exportedSpecificationGroup.getObjectNode()));
    }

    public void visit(ExportedSpecification exportedSpecification, ZipOutputStream zipOut, String entryPath) throws IOException {
        ExportImportUtils.writeSystemObject((ZipOutputStream)zipOut, (String)(entryPath + ExportImportUtils.generateSpecificationFileExportName((String)exportedSpecification.getId())), (String)this.yamlMapper.writeValueAsString((Object)exportedSpecification.getObjectNode()));
    }

    public void visit(ExportedSpecificationSource exportedSpecificationSource, ZipOutputStream zipOut, String entryPath) throws IOException {
        if (exportedSpecificationSource.getSource() == null) {
            log.warn("Can't find source for specification {}", (Object)exportedSpecificationSource.getId());
            return;
        }
        ExportImportUtils.writeSystemObject((ZipOutputStream)zipOut, (String)(entryPath + exportedSpecificationSource.getName()), (String)exportedSpecificationSource.getSource());
    }
}

