/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationSource;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedIntegrationSystem;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSpecification;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSpecificationGroup;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSpecificationSource;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSystemObject;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.ImportFileMigrationUtils;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.serializer.ExportableObjectWriterVisitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceSerializer {
    private final YAMLMapper yamlMapper;
    private final ExportableObjectWriterVisitor exportableObjectWriterVisitor;

    @Autowired
    public ServiceSerializer(YAMLMapper yamlExportImportMapper, ExportableObjectWriterVisitor exportableObjectWriterVisitor) {
        this.yamlMapper = yamlExportImportMapper;
        this.exportableObjectWriterVisitor = exportableObjectWriterVisitor;
    }

    public ExportedSystemObject serialize(IntegrationSystem system) throws JsonProcessingException {
        ObjectNode systemNode = (ObjectNode)this.yamlMapper.valueToTree((Object)system);
        ArrayList<ExportedSpecificationGroup> exportedSpecificationGroups = new ArrayList<ExportedSpecificationGroup>();
        for (SpecificationGroup specificationGroup : system.getSpecificationGroups()) {
            ArrayList<ExportedSpecification> exportedSpecifications = new ArrayList<ExportedSpecification>();
            for (SystemModel specification : specificationGroup.getSystemModels()) {
                exportedSpecifications.add(this.serialize(specification));
            }
            exportedSpecificationGroups.add(new ExportedSpecificationGroup(specificationGroup.getId(), (ObjectNode)this.yamlMapper.valueToTree((Object)specificationGroup), exportedSpecifications));
        }
        this.provideFileAdditionalData(systemNode);
        return new ExportedIntegrationSystem(system.getId(), systemNode, exportedSpecificationGroups);
    }

    public ExportedSpecification serialize(SystemModel specification) {
        ObjectNode specificationNode = (ObjectNode)this.yamlMapper.valueToTree((Object)specification);
        ArrayNode specificationSourcesNodes = null;
        ArrayList<ExportedSpecificationSource> exportedSpecificationSources = new ArrayList<ExportedSpecificationSource>();
        for (SpecificationSource source : specification.getSpecificationSources()) {
            exportedSpecificationSources.add(new ExportedSpecificationSource(source.getId(), source.getSource(), ExportImportUtils.getFullSpecificationFileName((SpecificationSource)source)));
            ObjectNode specificationSourceNode = (ObjectNode)this.yamlMapper.valueToTree((Object)source);
            specificationSourceNode.remove("modifiedWhen");
            specificationSourceNode.put("fileName", ExportImportUtils.getFullSpecificationFileName((SpecificationSource)source));
            if (specificationSourcesNodes == null) {
                specificationNode.putArray("specificationSources");
                specificationSourcesNodes = (ArrayNode)specificationNode.get("specificationSources");
            }
            specificationSourcesNodes.add((JsonNode)specificationSourceNode);
        }
        return new ExportedSpecification(specification.getId(), specificationNode, exportedSpecificationSources);
    }

    public byte[] writeSerializedArchive(List<ExportedSystemObject> exportedSystems) {
        byte[] byArray;
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            try (ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (ExportedSystemObject exportedSystem : exportedSystems) {
                    String entryPath = "services" + File.separator + exportedSystem.getId() + File.separator;
                    exportedSystem.accept(this.exportableObjectWriterVisitor, zipOut, entryPath);
                }
            }
            byArray = fos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unknown exception while archive creation: " + e.getMessage(), e);
            }
        }
        fos.close();
        return byArray;
    }

    private void provideFileAdditionalData(ObjectNode serviceNode) {
        serviceNode.put("migrations", ImportFileMigrationUtils.getActualServiceFileMigrationVersions().stream().sorted().toList().toString());
    }
}

