/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates;

import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.model.library.ElementType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateService.class);
    private static final String TEMPLATE_FOLDER = "/elements";
    private static final String SHARED_TEMPLATE_FOLDER = "/shared";
    private static final String SHARED_TEMPLATE_SUFFIX = ".hbs";
    private static final String DEFAULT_TEMPLATE_SUFFIX = "/template.hbs";
    private static final String COMPOSITE_TRIGGER_DIR_SUFFIX = "/trigger";
    private static final String COMPOSITE_TRIGGER_MODULE_DIR_SUFFIX = "/module";
    private final Handlebars handlebars;
    private final LibraryElementsService libraryService;

    @Autowired
    public TemplateService(ListableBeanFactory beanFactory, LibraryElementsService libraryService) {
        this.libraryService = libraryService;
        this.handlebars = new Handlebars().with(new TemplateLoader[]{new ClassPathTemplateLoader(TEMPLATE_FOLDER, DEFAULT_TEMPLATE_SUFFIX), new ClassPathTemplateLoader(SHARED_TEMPLATE_FOLDER, SHARED_TEMPLATE_SUFFIX)}).with(EscapingStrategy.NOOP);
        this.handlebars.setInfiniteLoops(true);
        this.handlebars.setPrettyPrint(true);
        this.handlebars.registerHelpers(StringHelpers.class);
        this.handlebars.registerHelpers(ConditionalHelpers.class);
        this.registerCustomHelpers(beanFactory);
    }

    private void registerCustomHelpers(ListableBeanFactory beanFactory) {
        Map helpers = beanFactory.getBeansWithAnnotation(TemplatesHelper.class);
        for (Object bean : helpers.values()) {
            if (bean instanceof Helper) {
                Helper helper = (Helper)bean;
                TemplatesHelper annotation = bean.getClass().getAnnotation(TemplatesHelper.class);
                String name = annotation.value();
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Registering Handlebars helper {} ({})", (Object)name, (Object)helper.getClass().getName());
                }
                this.handlebars.registerHelper(name, helper);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Registering Handlebars helpers {}", (Object)bean.getClass().getName());
            }
            this.handlebars.registerHelpers(bean);
        }
    }

    public String applyTemplate(ChainElement element) {
        String renderedElement;
        Template template = this.getTemplate(element);
        if (template == null) {
            throw new SnapshotCreationException("Element is not supposed to be outside a parent container.", element);
        }
        try {
            renderedElement = template.apply((Object)element);
        }
        catch (IOException | RuntimeException e) {
            log.warn("Error while applying template to the element {}: {}", (Object)element.getType(), (Object)e.getMessage());
            if (e.getCause() instanceof SnapshotCreationException) {
                if (StringUtils.isBlank((CharSequence)((SnapshotCreationException)e.getCause()).getElementId())) {
                    throw new SnapshotCreationException(e.getCause().getMessage(), element, e);
                }
                throw (SnapshotCreationException)e.getCause();
            }
            throw new SnapshotCreationException("Fields are not properly defined or require mandatory connection", element, e);
        }
        return renderedElement;
    }

    public Template getTemplate(ChainElement element) {
        return this.libraryService.getElementDescriptor(element).getType() == ElementType.COMPOSITE_TRIGGER ? this.getTemplate(element.getType() + (element.getInputDependencies().isEmpty() && element.getParent() == null ? COMPOSITE_TRIGGER_DIR_SUFFIX : COMPOSITE_TRIGGER_MODULE_DIR_SUFFIX)) : this.getTemplate(element.getType());
    }

    public Template getTemplate(String name) {
        try {
            return this.handlebars.compile(name);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            log.error("Can't initialize template for {}", (Object)name, (Object)e);
        }
        return null;
    }
}

