/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.util.MaasUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHelper {
    private static final Logger log = LoggerFactory.getLogger(BaseHelper.class);

    public String getPropertyStringValue(String propertyName, Options options) {
        Object property = this.getPropertyValue(propertyName, options);
        return property != null ? property.toString() : null;
    }

    public Object getPropertyValue(String propertyName, Options options) {
        Object context = options.context.model();
        if (context instanceof ChainElement) {
            ChainElement element = (ChainElement)context;
            String elementType = element.getType();
            if (BaseHelper.isMaasParamProperty(propertyName, elementType, element)) {
                return MaasUtils.getMaasParamPlaceholder(element.getOriginalId(), propertyName);
            }
            return element.getProperty(propertyName);
        }
        if (context instanceof Map) {
            Map map = (Map)context;
            return map.get(propertyName);
        }
        throw new IllegalArgumentException("Can't extract property " + propertyName + " from the instance of class: " + context.getClass().toString());
    }

    private static boolean isMaasParamProperty(String propertyName, String elementType, ChainElement element) {
        ArrayList<String> maasParamList;
        Map elementProperties = element.getProperties();
        String operationProtocolType = (String)elementProperties.get("integrationOperationProtocolType");
        return (BaseHelper.isTopicProperty(propertyName, elementType) && BaseHelper.isKafkaTrigger2OrKafkaSender2Component(elementType) || BaseHelper.isOperationPathProperty(propertyName, elementType) && BaseHelper.isOperationProtocolTypeKafka(operationProtocolType) && BaseHelper.isServiceCallOrAsyncApiTriggerComponent(elementType)) && !(maasParamList = MaasUtils.getMaasParams(element)).isEmpty();
    }

    private static boolean isOperationProtocolTypeKafka(String operationProtocolType) {
        return StringUtils.isNotEmpty((CharSequence)operationProtocolType) && StringUtils.equalsIgnoreCase((CharSequence)operationProtocolType, (CharSequence)"kafka");
    }

    private static boolean isTopicProperty(String propertyName, String elementType) {
        return StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"topics") && StringUtils.isNotBlank((CharSequence)elementType);
    }

    private static boolean isOperationPathProperty(String propertyName, String elementType) {
        return StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"integrationOperationPath") && StringUtils.isNotBlank((CharSequence)elementType);
    }

    private static boolean isKafkaTrigger2OrKafkaSender2Component(String elementType) {
        return StringUtils.equalsIgnoreCase((CharSequence)elementType, (CharSequence)"kafka-trigger-2") || StringUtils.equalsIgnoreCase((CharSequence)elementType, (CharSequence)"kafka-sender-2");
    }

    private static boolean isServiceCallOrAsyncApiTriggerComponent(String elementType) {
        return StringUtils.equalsIgnoreCase((CharSequence)elementType, (CharSequence)"service-call") || StringUtils.equalsIgnoreCase((CharSequence)elementType, (CharSequence)"async-api-trigger");
    }

    protected Options.Buffer putCollectionAsContext(Iterable<?> objects, Options options) throws IOException {
        for (Object child : objects) {
            this.putObjectAsChildContext(child, options);
        }
        return options.buffer();
    }

    protected Options.Buffer putObjectAsChildContext(Object object, Options options) throws IOException {
        Context parentContext = options.context;
        Options.Buffer buffer = options.buffer();
        Context childContext = Context.newContext((Context)parentContext, (Object)object);
        CharSequence charSequence = options.apply(options.fn, childContext);
        buffer.append(charSequence);
        return buffer;
    }
}

