/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.catalog.util.HashUtils;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;
import org.qubership.integration.platform.runtime.catalog.util.MaasUtils;
import org.springframework.beans.factory.annotation.Value;

@TemplatesHelper
public class EndpointHelperSource {
    @Value(value="${qip.gateway.egress.url}")
    private String gatewayUrl;
    @Value(value="${qip.gateway.egress.protocol}")
    private String gatewayProtocol;
    @Value(value="${qip.control-plane.chain-routes-registration.egress-gateway:true}")
    private boolean registerOnEgress;
    @Value(value="${qip.gateway.service-path-prefix:/qip/}")
    private String gatewayServicePathPrefix;
    private static final String ADDRESS_IS_EMPTY_MSG = "Please fill environment address field on the service.";
    private static final String NO_ACTIVE_ENVIRONMENT_MSG = "Please select active environment on the service.";
    private static final String NO_SERVICE_MSG = "Please check required services.";

    @PostConstruct
    private void afterInit() {
        if (!this.gatewayServicePathPrefix.startsWith("/")) {
            this.gatewayServicePathPrefix = "/" + this.gatewayServicePathPrefix;
        }
        if (!this.gatewayServicePathPrefix.endsWith("/")) {
            this.gatewayServicePathPrefix = this.gatewayServicePathPrefix + "/";
        }
    }

    public CharSequence integrationAddress(ChainElement element) {
        String type = element.getPropertyAsString("systemType");
        String address = "";
        ServiceEnvironment environment = element.getEnvironment();
        switch (type) {
            case "EXTERNAL": {
                if (environment == null) {
                    throw new SnapshotCreationException(NO_ACTIVE_ENVIRONMENT_MSG, element);
                }
                address = String.format("%s://%s/system/%s/%s", this.gatewayProtocol, this.gatewayUrl, element.getOriginalId(), HashUtils.sha1hex((String)environment.getAddress()));
                break;
            }
            case "INTERNAL": {
                if (environment == null) {
                    throw new SnapshotCreationException(NO_ACTIVE_ENVIRONMENT_MSG, element);
                }
                address = environment.getAddress();
                if (!StringUtils.isBlank((CharSequence)address)) break;
                throw new SnapshotCreationException(ADDRESS_IS_EMPTY_MSG, element);
            }
            case "IMPLEMENTED": {
                address = environment == null ? "" : environment.getAddress();
            }
        }
        return address;
    }

    public CharSequence integrationEndpoint(ChainElement element) {
        ServiceEnvironment environment = element.getEnvironment();
        ArrayList<String> maasParamList = MaasUtils.getMaasParams(element);
        if (environment == null) {
            throw new SnapshotCreationException(NO_SERVICE_MSG, element);
        }
        if (environment.isNotActivated()) {
            throw new SnapshotCreationException(NO_ACTIVE_ENVIRONMENT_MSG, element);
        }
        String endpoint = environment.getAddress();
        if (!maasParamList.isEmpty()) {
            endpoint = EndpointHelperSource.getMaasParam(element, endpoint);
        }
        if (StringUtils.isBlank((CharSequence)endpoint)) {
            throw new SnapshotCreationException(ADDRESS_IS_EMPTY_MSG, element);
        }
        return endpoint;
    }

    private static String getMaasParam(ChainElement element, String endpoint) {
        Map elementProperties = element.getProperties();
        if (StringUtils.equalsIgnoreCase((CharSequence)"kafka", (CharSequence)((String)elementProperties.get("integrationOperationProtocolType")))) {
            endpoint = MaasUtils.getMaasParamPlaceholder(element.getOriginalId(), "brokers");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"amqp", (CharSequence)((String)elementProperties.get("integrationOperationProtocolType")))) {
            endpoint = MaasUtils.getMaasParamPlaceholder(element.getOriginalId(), "addresses");
        }
        return endpoint;
    }

    public CharSequence gatewayURI(ChainElement element) {
        return this.gatewayUrl + "/" + element.getType() + "/" + element.getId();
    }

    private CharSequence manualGatewayPath(ChainElement element) {
        Object path = this.gatewayServicePathPrefix;
        if ("service-call".equals(element.getType())) {
            String systemId = element.getPropertyAsString("integrationSystemId");
            if (StringUtils.isBlank((CharSequence)systemId)) {
                throw new SnapshotCreationException(NO_SERVICE_MSG, element);
            }
            path = (String)path + systemId;
        } else {
            path = (String)path + element.getOriginalId();
        }
        return path;
    }

    public CharSequence gatewayProtocol(ChainElement element) {
        return this.gatewayProtocol;
    }

    public CharSequence gatewayUrl(ChainElement element) {
        return this.gatewayUrl;
    }

    @Deprecated(since="24.4")
    public CharSequence routeVariable(ChainElement element) {
        return this.externalRoutePath(element);
    }

    public CharSequence externalRoutePath(ChainElement element) {
        if (this.registerOnEgress) {
            return String.format("%%%%{%s}", ElementUtils.buildRouteVariableName((ChainElement)element));
        }
        return this.manualGatewayPath(element);
    }
}

