/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.model.constant.CamelNames;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;
import org.qubership.integration.platform.runtime.catalog.util.MaasUtils;

@TemplatesHelper
public class EnvironmentPropertiesHelper {
    private static final ObjectMapper OBJECT_MAPPER = EnvironmentPropertiesHelper.initObjectMapper();
    private static final String[] KAFKA_MAAS_PARAM_ARRAY = new String[]{"securityProtocol", "saslMechanism", "saslJaasConfig"};
    public static final ArrayList<String> KAFKA_MAAS_PARAM_LIST = new ArrayList<String>(Arrays.asList(KAFKA_MAAS_PARAM_ARRAY));
    private static final String[] AMQP_MAAS_PARAM_ARRAY = new String[]{"vhost", "username", "password", "sslProtocol"};
    public static final ArrayList<String> AMQP_MAAS_PARAM_LIST = new ArrayList<String>(Arrays.asList(AMQP_MAAS_PARAM_ARRAY));

    public Map<String, Object> environmentProperties(ChainElement element) {
        ServiceEnvironment environment = element.getEnvironment();
        if (environment == null) {
            throw new SnapshotCreationException("Couldn't find service or active service environment.", element);
        }
        Map environmentProperties = environment.getProperties();
        if (environmentProperties != null) {
            Map<String, Object> mergedProperties = ElementUtils.mergeProperties((Map)ElementUtils.extractServiceCallProperties((Map)element.getProperties()), (Map)environmentProperties).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return mergedProperties;
        }
        return null;
    }

    public CharSequence environmentPropertiesJson(ChainElement element) {
        Map<String, Object> props = this.environmentProperties(element);
        if (props == null) {
            return "";
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(props);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error processing json in environmentPropertiesJson helper", e);
        }
    }

    public Map<String, Object> asyncProperties(ChainElement element) {
        ServiceEnvironment environment = element.getEnvironment();
        if (environment == null) {
            throw new SnapshotCreationException("Couldn't find service or active service environment.", element);
        }
        ArrayList<String> maasParamList = MaasUtils.getMaasParams(element);
        if (environment.getProperties() != null) {
            if (!maasParamList.isEmpty()) {
                EnvironmentPropertiesHelper.putMassParams(element, environment);
            }
            Map filteredEnvProperties = environment.getProperties();
            Map<String, Object> mergedProperties = ElementUtils.mergeProperties((Map)ElementUtils.extractOperationAsyncProperties((Map)element.getProperties()), (Map)filteredEnvProperties).entrySet().stream().filter(EnvironmentPropertiesHelper.filterAsyncProperties()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return mergedProperties;
        }
        return null;
    }

    public CharSequence asyncPropertiesJson(ChainElement element) {
        Map<String, Object> props = this.asyncProperties(element);
        if (props == null) {
            return "";
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(props);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error processing json in environmentPropertiesJson helper", e);
        }
    }

    private static void putMassParams(ChainElement element, ServiceEnvironment environment) {
        Map elementProperties = element.getProperties();
        ArrayList<Object> maasParamList = new ArrayList();
        String operationProtocolType = "";
        if (elementProperties.get("integrationOperationProtocolType") != null) {
            operationProtocolType = (String)elementProperties.get("integrationOperationProtocolType");
        }
        if (StringUtils.isNotEmpty((CharSequence)operationProtocolType)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"kafka", (CharSequence)operationProtocolType)) {
                maasParamList = KAFKA_MAAS_PARAM_LIST;
            } else if (StringUtils.isNotEmpty((CharSequence)operationProtocolType) && StringUtils.equalsIgnoreCase((CharSequence)"amqp", (CharSequence)operationProtocolType)) {
                maasParamList = AMQP_MAAS_PARAM_LIST;
            }
            for (String string : maasParamList) {
                environment.getProperties().put(string, MaasUtils.getMaasParamPlaceholder(element.getOriginalId(), string));
            }
        }
    }

    public Map<String, Object> grpcProperties(ChainElement element) {
        ServiceEnvironment environment = element.getEnvironment();
        if (Objects.isNull(environment)) {
            throw new SnapshotCreationException("Couldn't find service or active service environment.", element);
        }
        Map<String, Object> properties = Stream.of(Optional.ofNullable(environment.getProperties()).orElse(Collections.emptyMap()), ElementUtils.extractGrpcProperties((Map)element.getProperties())).map(Map::entrySet).flatMap(Collection::stream).filter(EnvironmentPropertiesHelper.grpcProperties()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue));
        return properties;
    }

    private static Predicate<Map.Entry<String, Object>> grpcProperties() {
        return prop -> Objects.nonNull(prop.getValue()) && CamelNames.GRPC_PROPERTY_NAMES.contains(prop.getKey());
    }

    public CharSequence grpcPropertiesJson(ChainElement element) {
        try {
            return OBJECT_MAPPER.writeValueAsString(this.grpcProperties(element));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error processing json in environmentPropertiesJson helper", e);
        }
    }

    private static Predicate<Map.Entry<String, Object>> filterAsyncProperties() {
        return prop -> prop.getValue() != null && !((String)prop.getKey()).startsWith("maas.");
    }

    private static ObjectMapper initObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }
}

