/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.mapper;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.qubership.integration.platform.runtime.catalog.mapper.MapperException;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ArrayType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ComplexType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.CompoundType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.DataType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ObjectType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ReferenceType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeDefinition;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeWithDefinitions;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.Element;

public class DataTypeUtils {
    public static ResolveResult resolveType(DataType type, Map<String, TypeDefinition> definitionMap) {
        while (type instanceof ReferenceType) {
            String id;
            ReferenceType referenceType = (ReferenceType)type;
            TypeDefinition definition = (definitionMap = DataTypeUtils.updateDefinitionMapFromType(definitionMap, referenceType)).get(id = referenceType.getDefinitionId());
            if (Objects.isNull(definition)) {
                String message = String.format("Failed to resolve type definition with id: %s.", id);
                throw new MapperException(message);
            }
            type = definition.getType();
        }
        return new ResolveResult(type, definitionMap);
    }

    public static Map<String, TypeDefinition> updateDefinitionMapFromType(Map<String, TypeDefinition> definitionMap, DataType dataType) {
        TypeWithDefinitions type;
        if (dataType instanceof TypeWithDefinitions && !(type = (TypeWithDefinitions)dataType).getDefinitions().isEmpty()) {
            HashMap<String, TypeDefinition> result = new HashMap<String, TypeDefinition>(definitionMap);
            type.getDefinitions().forEach(definition -> result.put(definition.getId(), (TypeDefinition)definition));
            return result;
        }
        return definitionMap;
    }

    public static Optional<DataType> findBranchByAttributeId(CompoundType type, String attributeId, Map<String, TypeDefinition> definitionMap) {
        return DataTypeUtils.getBranches(type, definitionMap).filter(resolveResult -> resolveResult.type() instanceof ComplexType).filter(resolveResult -> DataTypeUtils.hasAttribute(resolveResult.type(), attributeId, resolveResult.definitionMap())).map(ResolveResult::type).findFirst();
    }

    private static Stream<ResolveResult> getBranches(CompoundType type, Map<String, TypeDefinition> definitionMap) {
        Map<String, TypeDefinition> definitions = DataTypeUtils.updateDefinitionMapFromType(definitionMap, type);
        return type.getTypes().stream().map(t -> DataTypeUtils.resolveType(t, definitions)).flatMap(resolveResult -> {
            Stream<ResolveResult> stream;
            DataType patt0$temp = resolveResult.type();
            if (patt0$temp instanceof CompoundType) {
                CompoundType compoundType = (CompoundType)patt0$temp;
                stream = DataTypeUtils.getBranches(compoundType, resolveResult.definitionMap());
            } else {
                stream = Stream.of(resolveResult);
            }
            return stream;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasAttribute(DataType type, String attributeId, Map<String, TypeDefinition> definitionMap) {
        ResolveResult resolveResult = DataTypeUtils.resolveType(type, definitionMap);
        DataType dataType = resolveResult.type();
        if (dataType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dataType;
            if (objectType.getSchema().getAttributes().stream().map(Element::getId).anyMatch(attributeId::equals)) return true;
        }
        if ((dataType = resolveResult.type()) instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            if (DataTypeUtils.hasAttribute(arrayType.getItemType(), attributeId, DataTypeUtils.updateDefinitionMapFromType(resolveResult.definitionMap(), arrayType))) return true;
        }
        if (!((dataType = resolveResult.type()) instanceof CompoundType)) return false;
        CompoundType compoundType = (CompoundType)dataType;
        if (!DataTypeUtils.findBranchByAttributeId(compoundType, attributeId, DataTypeUtils.updateDefinitionMapFromType(resolveResult.definitionMap(), compoundType)).isPresent()) return false;
        return true;
    }

    public record ResolveResult(DataType type, Map<String, TypeDefinition> definitionMap) {
    }
}

