/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.mapper.atlasmap;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.json.v2.JsonDataSource;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.Constants;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.Properties;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.ReplaceAll;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.TrimLeft;
import io.atlasmap.v2.TrimRight;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlField;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.mapper.ComplexField;
import org.qubership.integration.platform.mapper.GeneratedField;
import org.qubership.integration.platform.runtime.catalog.mapper.DataTypeUtils;
import org.qubership.integration.platform.runtime.catalog.mapper.DictionaryEntryParser;
import org.qubership.integration.platform.runtime.catalog.mapper.ElementMapBuilder;
import org.qubership.integration.platform.runtime.catalog.mapper.MappingInterpretation;
import org.qubership.integration.platform.runtime.catalog.mapper.MappingInterpreter;
import org.qubership.integration.platform.runtime.catalog.mapper.atlasmap.DataTypeToFieldTypeConverter;
import org.qubership.integration.platform.runtime.catalog.mapper.atlasmap.xml.XmlTemplateBuilder;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.FieldKind;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.ToAtlasMapExpressionConverter;
import org.qubership.integration.platform.runtime.catalog.mapper.metadata.DataFormat;
import org.qubership.integration.platform.runtime.catalog.mapper.metadata.MetadataUtils;
import org.qubership.integration.platform.runtime.catalog.model.mapper.atlasmap.action.QIPCustomAction;
import org.qubership.integration.platform.runtime.catalog.model.mapper.atlasmap.action.QIPDefaultValueAction;
import org.qubership.integration.platform.runtime.catalog.model.mapper.atlasmap.action.QIPDictionaryAction;
import org.qubership.integration.platform.runtime.catalog.model.mapper.atlasmap.action.QIPFormatDateTimeAction;
import org.qubership.integration.platform.runtime.catalog.model.mapper.atlasmap.characteristic.PropertyCharacteristics;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ArrayType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ComplexType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.CompoundType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.DataType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.NullType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ObjectType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeDefinition;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeKind;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ValueExtractor;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.MappingDescription;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.action.AttributeReference;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.action.ConstantReference;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.action.ElementReference;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.action.ElementType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.action.MappingAction;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.action.Transformation;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.action.TransformationType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.Attribute;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.Element;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.MessageSchema;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.ObjectSchema;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.constant.Constant;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.constant.GeneratedValue;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.constant.GivenValue;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.constant.SupplierKind;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.constant.ValueGenerator;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.constant.ValueSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@MappingInterpretation(value="AtlasMap")
public class AtlasMapInterpreter
implements MappingInterpreter {
    private static final Logger log = LoggerFactory.getLogger(AtlasMapInterpreter.class);
    private static final String MAPPING_NAME = "QIP_Mapping_Configuration";
    private static final String SERIALIZE_CONFIGURATION_ERROR_MESSAGE = "Unable to serialize Atlas Map configuration.";
    private static final String MAPPING_CREATION_ERROR_MESSAGE = "Unable to create mapping for action: ";
    private static final String EMPTY_FIELDS_ERROR_MESSAGE = "Cannot define input or output fields.";
    private static final String INCORRECT_DATA_SOURCE_FORMAT_ERROR_MESSAGE = "Incorrect Data Source Format For ";
    private static final String UNABLE_TO_FIND_DEFINITION_ERROR_MESSAGE = "Unable to find definition with id = ";
    private static final String UNABLE_TO_FIND_ATTRIBUTE_ERROR_MESSAGE = "Unable to find attribute with id = ";
    private static final String UNABLE_TO_FIND_PROPERTY_ERROR_MESSAGE = "Unable to find property with id = ";
    private static final String UNABLE_TO_FIND_HEADER_ERROR_MESSAGE = "Unable to find header with id = ";
    private static final String UNABLE_TO_FIND_CONSTANT_ERROR_MESSAGE = "Unable to find constant with id = ";
    private static final String UNABLE_TO_DEFINE_DATA_FORMAT_ERROR_MESSAGE = "Unable to define data format.";
    private static final String UNABLE_TO_INTERPRETER_EXPRESSION = "Unable to interpreter expression: ";
    private static final String FAILED_TO_RESOLVE_FIELD_REFERENCE = "Failed to resolve field reference: ";
    private static final String COMBINE_ARRAY_AND_PRIMITIVE_INTO_ARRAY_ERROR_MESSAGE = "Can not combine array and primitive field into array.";
    private static final String COMBINE_SEVERAL_ARRAYS_ERROR_MESSAGE = "Can not combine several arrays.";
    private static final String MULTIPLE_FIELDS_AGGREGATION_ERROR_MESSAGE = "Transformation is mandatory for multiple fields aggregation.";
    private static final String UNKNOWN_TRANSFORMATION_ERROR_MESSAGE = "Unknown transformation: %s";
    private static final String UNKNOWN_CONSTANT_VALUE_GENERATOR_ERROR_MESSAGE = "Unknown constant value generator: %s";
    private static final String ATTRIBUTE_REFERENCE_PATH_IS_EMPTY_ERROR_MESSAGE = "Attribute reference path is empty.";
    private static final String URI_ATLAS_PREFIX = "atlas:cip";
    private static final String CURRENT_SCOPE = "current";
    private static final String CURRENT_PATH = "/current/";
    private static final String EXCHANGE_SCOPE = "camelExchangeProperty";
    private static final String EXCHANGE_PATH = "/camelExchangeProperty/";
    private static final String TARGET_DOC_ID = "target";
    private static final String SOURCE_DOC_ID = "source";
    private static final String CONSTANT_DOC_ID = "DOC.Properties.1";
    private static final String PROPERTIES_DOC_ID = "DOC.Properties.2";
    private static final Pattern XML_TEXT_PATH_PATTERN = Pattern.compile("\\/#text$");
    private final ObjectMapper objectMapper;
    private final DataTypeToFieldTypeConverter dataTypeToFieldTypeConverter;

    @Autowired
    public AtlasMapInterpreter(@Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.dataTypeToFieldTypeConverter = new DataTypeToFieldTypeConverter();
    }

    @Override
    public String getInterpretation(MappingDescription mappingDescription) {
        AtlasMapping atlasMapping = new AtlasMapping();
        atlasMapping.setName(MAPPING_NAME);
        this.fillDataSources(mappingDescription, atlasMapping);
        this.fillConstants(mappingDescription, atlasMapping);
        this.fillProperties(mappingDescription, atlasMapping);
        this.fillActions(mappingDescription, atlasMapping);
        try {
            return this.objectMapper.writeValueAsString((Object)atlasMapping);
        }
        catch (JsonProcessingException e) {
            throw new SnapshotCreationException(SERIALIZE_CONFIGURATION_ERROR_MESSAGE);
        }
    }

    private void fillDataSources(MappingDescription mappingDescription, AtlasMapping atlasMapping) {
        if (mappingDescription.getSource().getBody().getKind() != TypeKind.NULL) {
            atlasMapping.getDataSource().add(this.getDataSource(DataSourceType.SOURCE.value().toLowerCase(), mappingDescription.getSource(), DataSourceType.SOURCE, Collections.emptyMap()));
        }
        if (mappingDescription.getTarget().getBody().getKind() != TypeKind.NULL) {
            atlasMapping.getDataSource().add(this.getDataSource(DataSourceType.TARGET.value().toLowerCase(), mappingDescription.getTarget(), DataSourceType.TARGET, Collections.emptyMap()));
        }
        this.fillAdditionalDataSources(mappingDescription, atlasMapping);
    }

    private void fillAdditionalDataSources(MappingDescription mappingDescription, AtlasMapping atlasMapping) {
        if (!mappingDescription.getSource().getProperties().isEmpty()) {
            mappingDescription.getSource().getProperties().stream().filter(property -> property.getType() instanceof ComplexType).forEach(property -> this.fillPropertyDataSources((Attribute)property, DataSourceType.SOURCE, atlasMapping));
        }
        if (!mappingDescription.getTarget().getProperties().isEmpty()) {
            mappingDescription.getTarget().getProperties().stream().filter(property -> property.getType() instanceof ComplexType).forEach(property -> this.fillPropertyDataSources((Attribute)property, DataSourceType.TARGET, atlasMapping));
        }
        mappingDescription.getConstants().stream().filter(constant -> constant.getValueSupplier().getKind().equals((Object)SupplierKind.GENERATED)).map(this::createDataSourceForConstantWithGeneratedValue).forEach(atlasMapping.getDataSource()::add);
    }

    private DataSource createDataSourceForConstantWithGeneratedValue(Constant constant) {
        DataSource dataSource = new DataSource();
        dataSource.setDataSourceType(DataSourceType.SOURCE);
        dataSource.setId(constant.getId());
        dataSource.setName(constant.getName() + "-" + constant.getId());
        ValueGenerator generator = ((GeneratedValue)constant.getValueSupplier()).getGenerator();
        dataSource.setUri(this.buildGeneratedValueUri(constant.getId(), generator));
        return dataSource;
    }

    private String buildGeneratedValueUri(String id, ValueGenerator generator) {
        ArrayList<BasicNameValuePair> queryParameters = new ArrayList<BasicNameValuePair>();
        queryParameters.add(new BasicNameValuePair("name", generator.getName()));
        generator.getParameters().stream().map(value -> new BasicNameValuePair("parameter", value)).forEachOrdered(queryParameters::add);
        return "atlas:cip:generated:" + id + "?" + URLEncodedUtils.format(queryParameters, (Charset)StandardCharsets.UTF_8);
    }

    private void fillPropertyDataSources(Attribute property, DataSourceType direction, AtlasMapping atlasMapping) {
        DataType body = switch (property.getType().getKind()) {
            case TypeKind.OBJECT -> property.getType();
            case TypeKind.ARRAY -> ((ArrayType)property.getType()).getItemType();
            default -> new NullType(null);
        };
        MessageSchema propertyDataSourceSchema = new MessageSchema(null, null, body, null);
        if (propertyDataSourceSchema.getBody().getKind() != TypeKind.NULL) {
            Map<String, String> parameters = DataSourceType.TARGET.equals((Object)direction) ? Collections.singletonMap("serializeTargetDocument", "false") : Collections.emptyMap();
            atlasMapping.getDataSource().add(this.getDataSource(property.getName(), propertyDataSourceSchema, direction, parameters));
        }
    }

    private DataSource getDataSource(String dataSourceName, MessageSchema dataSourceSchema, DataSourceType dataSourceType, Map<String, String> parameters) {
        DataFormat dataFormat = DataFormat.JSON;
        DataType dataType = dataSourceSchema.getBody();
        if (dataType instanceof ComplexType) {
            ComplexType body = (ComplexType)dataType;
            dataFormat = MetadataUtils.getDataFormat(body.getMetadata());
        }
        JsonDataSource dataSource = switch (dataFormat) {
            case DataFormat.UNSPECIFIED, DataFormat.JSON -> new JsonDataSource();
            case DataFormat.XML -> {
                XmlDataSource xmlDataSource = new XmlDataSource();
                XmlTemplateBuilder xmlTemplateBuilder = new XmlTemplateBuilder();
                try {
                    String templateText = xmlTemplateBuilder.setType(dataSourceSchema.getBody()).build();
                    xmlDataSource.setTemplate(templateText);
                }
                catch (Exception exception) {
                    throw new SnapshotCreationException("Failed to create XML document template", null, exception);
                }
                yield xmlDataSource;
            }
            default -> throw new SnapshotCreationException(INCORRECT_DATA_SOURCE_FORMAT_ERROR_MESSAGE.concat(dataSourceType.value()));
        };
        dataSource.setId(dataSourceName);
        dataSource.setName(dataSourceName);
        dataSource.setDescription(dataSourceName);
        dataSource.setUri(AtlasMapInterpreter.buildDataSourceUri(dataSourceName, dataFormat, parameters));
        dataSource.setDataSourceType(dataSourceType);
        return dataSource;
    }

    private static String buildDataSourceUri(String name, DataFormat format, Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(URI_ATLAS_PREFIX).append(":").append((DataFormat.UNSPECIFIED.equals((Object)format) ? DataFormat.JSON : format).name().toLowerCase(Locale.ROOT)).append(":").append(name);
        if (!parameters.isEmpty()) {
            sb.append("?");
            sb.append(parameters.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&")));
        }
        return sb.toString();
    }

    private void fillConstants(MappingDescription mappingDescription, AtlasMapping atlasMapping) {
        List<io.atlasmap.v2.Constant> constantList = mappingDescription.getConstants().stream().filter(constant -> constant.getValueSupplier().getKind().equals((Object)SupplierKind.GIVEN)).map(this::getConstant).toList();
        Constants constants = new Constants();
        constants.getConstant().addAll(constantList);
        atlasMapping.setConstants(constants);
    }

    private io.atlasmap.v2.Constant getConstant(Constant constant) {
        io.atlasmap.v2.Constant atlasMapConstant = new io.atlasmap.v2.Constant();
        atlasMapConstant.setName(constant.getName());
        atlasMapConstant.setFieldType(this.dataTypeToFieldTypeConverter.convert(constant.getType()));
        atlasMapConstant.setValue(this.getConstantValue(constant));
        return atlasMapConstant;
    }

    private String getConstantValue(Constant constant) {
        ValueSupplier valueSupplier = constant.getValueSupplier();
        return SupplierKind.GIVEN.equals((Object)valueSupplier.getKind()) ? ((GivenValue)valueSupplier).getValue() : constant.getName();
    }

    private void fillProperties(MappingDescription mappingDescription, AtlasMapping atlasMapping) {
        Properties properties = new Properties();
        atlasMapping.setProperties(properties);
        atlasMapping.getProperties().getProperty().addAll(this.getProperties(mappingDescription.getSource().getHeaders(), CURRENT_SCOPE, DataSourceType.SOURCE));
        atlasMapping.getProperties().getProperty().addAll(this.getProperties(mappingDescription.getSource().getProperties(), EXCHANGE_SCOPE, DataSourceType.SOURCE));
        atlasMapping.getProperties().getProperty().addAll(this.getProperties(mappingDescription.getTarget().getHeaders(), CURRENT_SCOPE, DataSourceType.TARGET));
        atlasMapping.getProperties().getProperty().addAll(this.getProperties(mappingDescription.getTarget().getProperties(), EXCHANGE_SCOPE, DataSourceType.TARGET));
    }

    private List<Property> getProperties(Collection<Attribute> properties, String scope, DataSourceType dataSourceType) {
        return properties.stream().filter(attribute -> !(attribute.getType() instanceof ComplexType)).map(attribute -> this.getProperty((Attribute)attribute, scope, dataSourceType)).collect(Collectors.toList());
    }

    private Property getProperty(Attribute attribute, String scope, DataSourceType dataSourceType) {
        Property atlasMapProperty = new Property();
        atlasMapProperty.setName(attribute.getName());
        atlasMapProperty.setFieldType(this.dataTypeToFieldTypeConverter.convert(attribute.getType()));
        atlasMapProperty.setScope(scope);
        atlasMapProperty.setDataSourceType(dataSourceType);
        atlasMapProperty.setValue(attribute.getDefaultValue());
        return atlasMapProperty;
    }

    private void fillActions(MappingDescription mappingDescription, AtlasMapping atlasMapping) {
        Map<String, ElementMapBuilder.ElementWithContext> sourceElementMap = this.buildElementMap(mappingDescription.getSource(), mappingDescription.getConstants());
        Map<String, ElementMapBuilder.ElementWithContext> targetElementMap = this.buildElementMap(mappingDescription.getTarget(), Collections.emptyList());
        List mappings = mappingDescription.getActions().stream().sorted(Comparator.comparing(action -> action.getTarget().getPath().size())).flatMap(action -> this.getMappings(mappingDescription, (MappingAction)action, sourceElementMap, targetElementMap).stream().map(mapping -> this.processTransformation(mappingDescription, (BaseMapping)mapping, (MappingAction)action, sourceElementMap, targetElementMap))).toList();
        atlasMapping.setMappings(new Mappings());
        atlasMapping.getMappings().getMapping().addAll(mappings);
    }

    private Map<String, ElementMapBuilder.ElementWithContext> buildElementMap(MessageSchema messageSchema, Collection<Constant> constants) {
        ElementMapBuilder elementMapBuilder = new ElementMapBuilder();
        HashMap<String, ElementMapBuilder.ElementWithContext> result = new HashMap<String, ElementMapBuilder.ElementWithContext>();
        Stream.of(messageSchema.getHeaders(), messageSchema.getProperties()).map(attributes -> new ObjectType(new ObjectSchema("", List.copyOf(attributes), null), null, null)).map(elementMapBuilder::buildElementMap).forEach(result::putAll);
        result.putAll(elementMapBuilder.buildElementMap(messageSchema.getBody()));
        constants.forEach(constant -> result.put(constant.getId(), new ElementMapBuilder.ElementWithContext((Element)constant, new ElementMapBuilder.ElementContext(Collections.emptyMap()))));
        return result;
    }

    private List<? extends BaseMapping> getMappings(MappingDescription mappingDescription, MappingAction action, Map<String, ElementMapBuilder.ElementWithContext> sourceElementMap, Map<String, ElementMapBuilder.ElementWithContext> targetElementMap) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        List<Field> inputFields = action.getSources().stream().map(source -> this.buildAtlasField((ElementReference)source, mappingDescription.getSource(), sourceElementMap, true)).toList();
        Field outputField = this.buildAtlasField(action.getTarget(), mappingDescription.getTarget(), targetElementMap, false);
        this.validateForSupportedMappings(inputFields, outputField, action);
        Mapping mapping = new Mapping();
        mapping.setId("mapping.".concat(UUID.randomUUID().toString()));
        mapping.getOutputField().add(outputField);
        boolean hasExpressionTransformation = Optional.ofNullable(action.getTransformation()).map(transformation -> transformation.getName().equals(TransformationType.EXPRESSION.getValue()) || transformation.getName().equals(TransformationType.CONDITIONAL.getValue())).orElse(false);
        if (inputFields.size() == 1 && !hasExpressionTransformation) {
            mapping.getInputField().add(inputFields.get(0));
            result.add(mapping);
            return result;
        }
        if (outputField.getCollectionType().equals((Object)CollectionType.ARRAY) && !(outputField instanceof ConstantField) && !(outputField instanceof PropertyField) && inputFields.stream().allMatch(field -> field.getCollectionType().equals((Object)CollectionType.NONE)) && !hasExpressionTransformation) {
            AtomicInteger arrayIndexCounter = new AtomicInteger(0);
            List<Mapping> mappings = inputFields.stream().map(inputField -> {
                int index = arrayIndexCounter.getAndIncrement();
                Mapping map = new Mapping();
                inputField.setIndex(Integer.valueOf(0));
                map.getInputField().add(inputField);
                Field outputFieldCopy = this.buildAtlasField(action.getTarget(), mappingDescription.getTarget(), targetElementMap, false);
                String indexedPath = this.getIndexedPath(outputFieldCopy.getPath(), index);
                this.replacePathPrefix(outputFieldCopy, outputFieldCopy.getPath(), indexedPath, false);
                map.getOutputField().add(outputFieldCopy);
                return map;
            }).toList();
            return mappings;
        }
        FieldGroup inputFieldGroup = new FieldGroup();
        inputFieldGroup.getField().addAll(inputFields);
        inputFieldGroup.setActions(new ArrayList());
        mapping.setInputFieldGroup(inputFieldGroup);
        result.add(mapping);
        return result;
    }

    private Field buildAtlasField(ElementReference elementReference, MessageSchema messageSchema, Map<String, ElementMapBuilder.ElementWithContext> elementMap, boolean isSource) {
        return switch (elementReference.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ElementType.CONSTANT -> this.buildConstantField(elementReference, elementMap);
            case ElementType.ATTRIBUTE -> {
                AttributeReference attributeReference = (AttributeReference)elementReference;
                switch (attributeReference.getKind()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case HEADER: {
                        yield this.buildHeaderField(attributeReference, elementMap);
                    }
                    case PROPERTY: {
                        yield this.buildPropertyField(attributeReference, elementMap);
                    }
                    case BODY: 
                }
                yield this.buildBodyField(attributeReference, messageSchema, isSource, elementMap);
            }
        };
    }

    private Field buildHeaderField(AttributeReference attributeReference, Map<String, ElementMapBuilder.ElementWithContext> elementMap) {
        String headerId = (String)attributeReference.getPath().stream().findFirst().orElseThrow(() -> new SnapshotCreationException(ATTRIBUTE_REFERENCE_PATH_IS_EMPTY_ERROR_MESSAGE));
        ElementMapBuilder.ElementWithContext attributeWithContext = elementMap.get(headerId);
        if (Objects.isNull(attributeWithContext)) {
            throw new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(UNABLE_TO_FIND_HEADER_ERROR_MESSAGE).concat(headerId));
        }
        Attribute header = (Attribute)attributeWithContext.element();
        return this.buildCommonPropertyField(header, new PropertyCharacteristics(CURRENT_SCOPE, CURRENT_PATH, PROPERTIES_DOC_ID));
    }

    private Field buildPropertyField(AttributeReference attributeReference, Map<String, ElementMapBuilder.ElementWithContext> elementMap) {
        List<String> path = attributeReference.getPath();
        String id = (String)path.stream().findFirst().orElseThrow(() -> new SnapshotCreationException(ATTRIBUTE_REFERENCE_PATH_IS_EMPTY_ERROR_MESSAGE));
        ElementMapBuilder.ElementWithContext attributeWithContext = elementMap.get(id);
        if (Objects.isNull(attributeWithContext)) {
            throw new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(UNABLE_TO_FIND_PROPERTY_ERROR_MESSAGE).concat(id));
        }
        Attribute root = (Attribute)attributeWithContext.element();
        DataType rootType = DataTypeUtils.resolveType(root.getType(), Collections.emptyMap()).type();
        if (rootType instanceof ComplexType) {
            if (path.size() == 1) {
                Field field = this.buildAttributeField(attributeReference, DataFormat.JSON, root.getName(), elementMap, false);
                String newPrefix = rootType.getKind().equals((Object)TypeKind.ARRAY) ? "<>/" : "/";
                this.replacePathPrefix(field, field.getPath(), newPrefix, true);
                return field;
            }
            boolean rootIsArray = rootType.getKind().equals((Object)TypeKind.ARRAY);
            return this.buildAttributeField(new AttributeReference(attributeReference.getKind(), attributeReference.getPath().subList(1, attributeReference.getPath().size()), attributeReference.getMetadata()), DataFormat.JSON, root.getName(), elementMap, rootIsArray);
        }
        if (path.size() == 1) {
            return this.buildCommonPropertyField(root, new PropertyCharacteristics(EXCHANGE_SCOPE, EXCHANGE_PATH, PROPERTIES_DOC_ID));
        }
        throw new SnapshotCreationException("Path length for scalar attribute is greater than 1");
    }

    private void replacePathPrefix(Field field, String oldPrefix, String newPrefix, boolean replaceExtraCharacter) {
        if (field.getPath().startsWith(oldPrefix)) {
            int index = replaceExtraCharacter ? Math.min(field.getPath().length(), oldPrefix.length() + 1) : oldPrefix.length();
            field.setPath(newPrefix + field.getPath().substring(index));
        }
        if (field instanceof ComplexField) {
            ((ComplexField)field).getChildFields().forEach(f -> this.replacePathPrefix((Field)f, oldPrefix, newPrefix, replaceExtraCharacter));
        }
    }

    /*
     * Unable to fully structure code
     */
    private Field buildBodyField(AttributeReference attributeReference, MessageSchema messageSchema, boolean isSource, Map<String, ElementMapBuilder.ElementWithContext> elementMap) {
        dataFormat = MetadataUtils.getDataFormat(messageSchema.getBody().getMetadata());
        documentId = isSource != false ? "source" : "target";
        bodyTypeResolveResult = DataTypeUtils.resolveType(messageSchema.getBody(), Collections.emptyMap());
        var10_8 = bodyTypeResolveResult.type();
        if (!(var10_8 instanceof CompoundType)) ** GOTO lbl-1000
        compoundType = (CompoundType)var10_8;
        if (!attributeReference.getPath().isEmpty()) {
            v0 = DataTypeUtils.findBranchByAttributeId(compoundType, attributeReference.getPath().get(0), bodyTypeResolveResult.definitionMap()).orElse(bodyTypeResolveResult.type());
        } else lbl-1000:
        // 2 sources

        {
            v0 = bodyTypeResolveResult.type();
        }
        rootType = v0;
        rootIsArray = rootType.getKind().equals((Object)TypeKind.ARRAY);
        field = this.buildAttributeField(attributeReference, dataFormat, documentId, elementMap, rootIsArray);
        return field;
    }

    private Field buildAttributeField(AttributeReference attributeReference, DataFormat dataFormat, String documentId, Map<String, ElementMapBuilder.ElementWithContext> elementMap, boolean rootIsArray) {
        ComplexField field;
        List<Element> path = this.resolveElementsForPath(attributeReference.getPath(), elementMap);
        if (path.isEmpty()) {
            throw new SnapshotCreationException(ATTRIBUTE_REFERENCE_PATH_IS_EMPTY_ERROR_MESSAGE);
        }
        Attribute lastAttribute = (Attribute)path.get(path.size() - 1);
        String fieldName = lastAttribute.getName();
        Object fieldPath = this.buildAtlasMapFieldPath(path, elementMap);
        if (rootIsArray) {
            fieldPath = "<>" + (String)fieldPath;
        }
        Map<String, TypeDefinition> definitionMap = elementMap.get(lastAttribute.getId()).context().definitionMap();
        DataTypeUtils.ResolveResult typeResolveResult = DataTypeUtils.resolveType(lastAttribute.getType(), definitionMap);
        DataType dataType = typeResolveResult.type();
        boolean isArray = dataType.getKind().equals((Object)TypeKind.ARRAY);
        if (isArray) {
            DataTypeUtils.ResolveResult itemTypeResolveResult = DataTypeUtils.resolveType(((ArrayType)dataType).getItemType(), typeResolveResult.definitionMap());
            dataType = itemTypeResolveResult.type();
        }
        if (dataType instanceof ArrayType) {
            field = new ComplexField();
            field.setName(fieldName);
            field.setPath((String)fieldPath);
            field.setFieldType(FieldType.ANY);
        }
        if (dataType instanceof CompoundType) {
            field = new ComplexField();
            field.setName(fieldName);
            field.setPath((String)fieldPath);
            field.setFieldType(FieldType.ANY);
        } else if (dataType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dataType;
            List<Field> childFields = objectType.getSchema().getAttributes().stream().map(attribute -> new AttributeReference(attributeReference.getKind(), ListUtils.union(attributeReference.getPath(), Collections.singletonList(attribute.getId())), null)).map(reference -> this.buildAttributeField((AttributeReference)reference, dataFormat, documentId, elementMap, rootIsArray)).toList();
            field = new ComplexField(childFields);
            field.setName(fieldName);
            field.setPath((String)fieldPath);
            field.setFieldType(FieldType.ANY);
        } else {
            switch (dataFormat) {
                case UNSPECIFIED: 
                case JSON: {
                    field = new JsonField();
                    field.setName(fieldName);
                    field.setPath((String)fieldPath);
                    break;
                }
                case XML: {
                    boolean isXmlAttribute = fieldName.startsWith("@");
                    Matcher pathMatcher = XML_TEXT_PATH_PATTERN.matcher((CharSequence)fieldPath);
                    if (pathMatcher.find()) {
                        fieldName = path.get(path.size() - 2).getName();
                        fieldPath = ((String)fieldPath).replaceAll(XML_TEXT_PATH_PATTERN.pattern(), "");
                    }
                    field = new XmlField();
                    ((XmlField)field).setAttribute(Boolean.valueOf(isXmlAttribute));
                    field.setName(fieldName);
                    field.setPath((String)fieldPath);
                    break;
                }
                default: {
                    throw new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(UNABLE_TO_DEFINE_DATA_FORMAT_ERROR_MESSAGE));
                }
            }
            field.setFieldType(this.dataTypeToFieldTypeConverter.convert(dataType, definitionMap));
        }
        field.setValue(ValueExtractor.getValue(dataType.getKind(), lastAttribute.getDefaultValue()));
        field.setDocId(documentId);
        field.setCollectionType(isArray ? CollectionType.ARRAY : CollectionType.NONE);
        return field;
    }

    private List<Element> resolveElementsForPath(List<String> path, Map<String, ElementMapBuilder.ElementWithContext> elementMap) {
        return path.stream().map(id -> Optional.ofNullable((ElementMapBuilder.ElementWithContext)elementMap.get(id)).map(ElementMapBuilder.ElementWithContext::element).orElseThrow(() -> new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(UNABLE_TO_FIND_ATTRIBUTE_ERROR_MESSAGE).concat((String)id)))).toList();
    }

    private String buildAtlasMapFieldPath(List<Element> path, Map<String, ElementMapBuilder.ElementWithContext> attributeMap) {
        return path.stream().map(attribute -> {
            ElementMapBuilder.ElementWithContext defaultAttributeContextInfo = new ElementMapBuilder.ElementWithContext((Element)attribute, new ElementMapBuilder.ElementContext(Collections.emptyMap()));
            DataTypeUtils.ResolveResult result = DataTypeUtils.resolveType(attribute.getType(), attributeMap.getOrDefault(attribute.getId(), defaultAttributeContextInfo).context().definitionMap());
            return result.type().getKind().equals((Object)TypeKind.ARRAY) ? attribute.getName().concat("<>") : attribute.getName();
        }).collect(Collectors.joining("/", "/", ""));
    }

    private Field buildConstantField(ElementReference elementReference, Map<String, ElementMapBuilder.ElementWithContext> attributeMap) {
        ConstantReference constantReference = (ConstantReference)elementReference;
        String constantId = constantReference.getConstantId();
        ElementMapBuilder.ElementWithContext attributeWithContext = attributeMap.get(constantId);
        if (Objects.isNull(attributeWithContext)) {
            throw new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(UNABLE_TO_FIND_CONSTANT_ERROR_MESSAGE).concat(constantId));
        }
        Constant constant = (Constant)attributeWithContext.element();
        if (constant.getValueSupplier().getKind().equals((Object)SupplierKind.GENERATED)) {
            GeneratedField field = new GeneratedField();
            field.setFieldType(this.dataTypeToFieldTypeConverter.convert(constant.getType()));
            field.setPath("/".concat(constant.getName()));
            field.setCollectionType(CollectionType.NONE);
            field.setDocId(constant.getId());
            return field;
        }
        ConstantField field = new ConstantField();
        field.setFieldType(this.dataTypeToFieldTypeConverter.convert(constant.getType()));
        field.setValue((Object)((GivenValue)constant.getValueSupplier()).getValue());
        field.setPath("/".concat(constant.getName()));
        field.setCollectionType(CollectionType.NONE);
        field.setDocId(CONSTANT_DOC_ID);
        return field;
    }

    private PropertyField buildCommonPropertyField(Attribute propertyAttribute, PropertyCharacteristics propertyCharacteristics) {
        PropertyField propertyField = new PropertyField();
        propertyField.setDocId(propertyCharacteristics.docId());
        propertyField.setName(propertyAttribute.getName());
        propertyField.setScope(propertyCharacteristics.scope());
        propertyField.setPath(propertyCharacteristics.path().concat(propertyAttribute.getName()));
        propertyField.setFieldType(this.dataTypeToFieldTypeConverter.convert(propertyAttribute.getType()));
        propertyField.setCollectionType(CollectionType.NONE);
        return propertyField;
    }

    private String getIndexedPath(String path, int index) {
        String result = path;
        result = result.replace("<>", "<0>");
        String postfix = result.substring(result.lastIndexOf("<0>") + 2);
        return result.substring(0, result.lastIndexOf("<0>") + 1).concat(String.valueOf(index)).concat(postfix);
    }

    private BaseMapping processTransformation(MappingDescription mappingDescription, BaseMapping mapping, MappingAction action, Map<String, ElementMapBuilder.ElementWithContext> sourceElementMap, Map<String, ElementMapBuilder.ElementWithContext> targetElementMap) {
        Transformation transformation = action.getTransformation();
        if (transformation == null) {
            return mapping;
        }
        Mapping processedMapping = null;
        if (mapping instanceof Mapping) {
            processedMapping = (Mapping)mapping;
            ArrayList<QIPCustomAction> actions = new ArrayList<QIPCustomAction>();
            TransformationType transformationType = TransformationType.fromValue(transformation.getName()).orElseThrow(() -> new SnapshotCreationException(String.format(UNKNOWN_TRANSFORMATION_ERROR_MESSAGE, transformation.getName())));
            switch (transformationType) {
                case DEFAULT_VALUE: {
                    String defaultValue = transformation.getParameters().get(0);
                    QIPDefaultValueAction qipDefaultValueAction = new QIPDefaultValueAction(defaultValue);
                    actions.add(qipDefaultValueAction);
                    break;
                }
                case FORMAT_DATE_TIME: {
                    QIPFormatDateTimeAction qipFormatDateTimeAction = new QIPFormatDateTimeAction(Boolean.valueOf(transformation.getParameters().get(0)), transformation.getParameters().get(1), transformation.getParameters().get(2), transformation.getParameters().get(3), Boolean.valueOf(transformation.getParameters().get(4)), transformation.getParameters().get(5), transformation.getParameters().get(6), transformation.getParameters().get(7));
                    actions.add(qipFormatDateTimeAction);
                    break;
                }
                case DICTIONARY: {
                    List<String> params = transformation.getParameters();
                    String defaultValue = params.get(0);
                    Map<String, String> lookupTable = transformation.getParameters().stream().skip(1L).map(DictionaryEntryParser::parse).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    QIPDictionaryAction qipDictionaryAction = new QIPDictionaryAction(defaultValue, lookupTable);
                    actions.add(qipDictionaryAction);
                    break;
                }
                case CONDITIONAL: {
                    this.setConditionalExpression(action.getTransformation().getParameters(), processedMapping);
                    return processedMapping;
                }
                case EXPRESSION: {
                    this.setCommonExpression(action.getTransformation().getParameters().get(0), processedMapping);
                    return processedMapping;
                }
                case TRIM: {
                    List<String> params = transformation.getParameters();
                    if (params.size() != 1) {
                        throw new SnapshotCreationException("Wrong number of parameters for 'trim' transformation.");
                    }
                    TrimLeft trimAction = switch (params.get(0)) {
                        case "left" -> new TrimLeft();
                        case "right" -> new TrimRight();
                        case "both" -> new Trim();
                        default -> {
                            String message = String.format("Wrong 'side' parameter value for 'trim' transformation: %s.", params.get(0));
                            throw new SnapshotCreationException(message);
                        }
                    };
                    actions.add((QIPCustomAction)trimAction);
                    break;
                }
                case REPLACE_ALL: {
                    List<String> params = transformation.getParameters();
                    if (params.size() != 2) {
                        throw new SnapshotCreationException("Wrong number of parameters for 'replaceAll' transformation.");
                    }
                    ReplaceAll replaceAllAction = new ReplaceAll();
                    replaceAllAction.setMatch(params.get(0));
                    replaceAllAction.setNewString(params.get(1));
                    actions.add((QIPCustomAction)replaceAllAction);
                }
            }
            ((Field)processedMapping.getInputField().get(0)).setActions(actions);
        }
        return processedMapping == null ? mapping : processedMapping;
    }

    private void setConditionalExpression(List<String> parameters, Mapping mapping) {
        String conditionalExpression = "IF ( " + parameters.get(0) + " , " + parameters.get(1) + " , " + parameters.get(2) + " )";
        this.setCommonExpression(conditionalExpression, mapping);
    }

    private void setCommonExpression(String expression, Mapping mapping) {
        ToAtlasMapExpressionConverter expressionConverter = new ToAtlasMapExpressionConverter();
        List inputFields = Objects.isNull(mapping.getInputFieldGroup()) ? mapping.getInputField() : mapping.getInputFieldGroup().getField();
        String convertedExpression = expressionConverter.convert(expression, fieldReference -> inputFields.stream().filter(field -> {
            FieldKind kind = fieldReference.kind();
            return FieldKind.CONSTANT.equals((Object)kind) && (field instanceof ConstantField || field instanceof GeneratedField) || FieldKind.PROPERTY.equals((Object)kind) && field instanceof PropertyField && !((PropertyField)field).getScope().equals(CURRENT_SCOPE) || FieldKind.PROPERTY.equals((Object)kind) && !(field instanceof ConstantField) && !(field instanceof PropertyField) && fieldReference.path().size() > 1 && field.getDocId().equals(fieldReference.path().get(0)) || FieldKind.HEADER.equals((Object)kind) && field instanceof PropertyField && ((PropertyField)field).getScope().equals(CURRENT_SCOPE) || FieldKind.BODY.equals((Object)kind) && !(field instanceof ConstantField) && !(field instanceof PropertyField);
        }).filter(field -> {
            String path = field.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (field instanceof PropertyField) {
                path = path.replaceAll("^(current|camelExchangeProperty)/", "");
            }
            List<String> referencePath = FieldKind.PROPERTY.equals((Object)fieldReference.kind()) && fieldReference.path().size() > 1 ? fieldReference.path().subList(1, fieldReference.path().size()) : fieldReference.path();
            return Arrays.stream(path.split("/")).map(name -> name.replaceAll("<>", "")).toList().equals(referencePath);
        }).map(field -> String.format("%s:%s", field.getDocId(), field.getPath())).findFirst().orElseThrow(() -> new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(UNABLE_TO_INTERPRETER_EXPRESSION).concat(expression).concat(" ").concat(FAILED_TO_RESOLVE_FIELD_REFERENCE).concat(fieldReference.toString()))));
        mapping.setExpression(convertedExpression);
    }

    private void validateForSupportedMappings(List<Field> inputFields, Field outputField, MappingAction action) {
        if (inputFields.isEmpty() || outputField == null) {
            throw new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(EMPTY_FIELDS_ERROR_MESSAGE));
        }
        if (inputFields.stream().anyMatch(field -> field.getCollectionType().equals((Object)CollectionType.ARRAY)) && inputFields.stream().anyMatch(field -> field.getCollectionType().equals((Object)CollectionType.NONE)) && outputField.getCollectionType().equals((Object)CollectionType.ARRAY) && action.getTransformation() == null) {
            throw new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(COMBINE_ARRAY_AND_PRIMITIVE_INTO_ARRAY_ERROR_MESSAGE));
        }
        if (inputFields.size() > 1 && inputFields.stream().anyMatch(field -> field.getCollectionType().equals((Object)CollectionType.ARRAY)) && outputField.getCollectionType().equals((Object)CollectionType.ARRAY) && action.getTransformation() == null) {
            throw new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(COMBINE_SEVERAL_ARRAYS_ERROR_MESSAGE));
        }
        if (inputFields.size() > 1 && action.getTransformation() == null && !outputField.getCollectionType().equals((Object)CollectionType.ARRAY)) {
            throw new SnapshotCreationException(MAPPING_CREATION_ERROR_MESSAGE.concat(MULTIPLE_FIELDS_AGGREGATION_ERROR_MESSAGE));
        }
    }
}

