/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.mapper.atlasmap;

import io.atlasmap.v2.FieldType;
import java.util.Collections;
import java.util.Map;
import org.qubership.integration.platform.runtime.catalog.mapper.DataTypeUtils;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ArrayType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.DataType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeDefinition;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeKind;

public class DataTypeToFieldTypeConverter {
    public FieldType convert(DataType type) {
        return this.convert(type, Collections.emptyMap());
    }

    public FieldType convert(DataType type, Map<String, TypeDefinition> definitionMap) {
        DataTypeUtils.ResolveResult result = DataTypeUtils.resolveType(type, definitionMap);
        return switch (result.type().getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.INTEGER -> FieldType.NUMBER;
            case TypeKind.BOOLEAN -> FieldType.BOOLEAN;
            case TypeKind.STRING -> FieldType.STRING;
            case TypeKind.OBJECT -> FieldType.COMPLEX;
            case TypeKind.ARRAY -> this.convert(((ArrayType)result.type()).getItemType(), result.definitionMap());
            case TypeKind.NULL, TypeKind.REFERENCE, TypeKind.ALL_OF, TypeKind.ANY_OF, TypeKind.ONE_OF -> FieldType.ANY;
        };
    }
}

