/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.mapper.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.EscapeUtil;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.FieldKind;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.FieldReference;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.parser.ExpressionParser;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.parser.ExpressionParserBaseVisitor;

public class ExpressionVisitor
extends ExpressionParserBaseVisitor<String> {
    private final Function<FieldReference, String> fieldIdResolver;

    public ExpressionVisitor(Function<FieldReference, String> fieldIdResolver) {
        this.fieldIdResolver = fieldIdResolver;
    }

    @Override
    public String visitOrExpression(ExpressionParser.OrExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    @Override
    public String visitOrOperator(ExpressionParser.OrOperatorContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitAndExpression(ExpressionParser.AndExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    @Override
    public String visitAndOperator(ExpressionParser.AndOperatorContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitEqualityExpression(ExpressionParser.EqualityExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    @Override
    public String visitEqualityOperator(ExpressionParser.EqualityOperatorContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitComparisonExpression(ExpressionParser.ComparisonExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    @Override
    public String visitComparisonOperator(ExpressionParser.ComparisonOperatorContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitAddExpression(ExpressionParser.AddExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    @Override
    public String visitAddOperator(ExpressionParser.AddOperatorContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitMultExpression(ExpressionParser.MultExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    @Override
    public String visitMultOperator(ExpressionParser.MultOperatorContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitUnaryExpression(ExpressionParser.UnaryExpressionContext ctx) {
        return Objects.isNull((Object)ctx.primaryExpression()) ? (String)this.visit((ParseTree)ctx.unaryOperator()) + (String)this.visit((ParseTree)ctx.unaryExpression()) : (String)this.visit((ParseTree)ctx.primaryExpression());
    }

    @Override
    public String visitUnaryOperator(ExpressionParser.UnaryOperatorContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitExpressionInBraces(ExpressionParser.ExpressionInBracesContext ctx) {
        return "(" + (String)this.visit((ParseTree)ctx.expression()) + ")";
    }

    @Override
    public String visitFunctionCall(ExpressionParser.FunctionCallContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(ctx.functionName().getText()).append("(");
        if (Objects.nonNull((Object)ctx.functionParameters())) {
            sb.append((String)this.visit((ParseTree)ctx.functionParameters()));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String visitFunctionName(ExpressionParser.FunctionNameContext ctx) {
        return (String)super.visitFunctionName(ctx);
    }

    @Override
    public String visitFunctionParameters(ExpressionParser.FunctionParametersContext ctx) {
        return ctx.expression().stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(", "));
    }

    @Override
    public String visitAttributeReference(ExpressionParser.AttributeReferenceContext ctx) {
        FieldKind kind = FieldKind.valueOf(ctx.attributeKind().getText().toUpperCase());
        List<String> path = ctx.path().pathElement().stream().map(RuleContext::getText).map(this::unescapePathElement).collect(Collectors.toList());
        FieldReference reference = new FieldReference(kind, path);
        return this.buildFieldReferenceText(reference);
    }

    @Override
    public String visitConstantReference(ExpressionParser.ConstantReferenceContext ctx) {
        FieldReference reference = new FieldReference(FieldKind.CONSTANT, Collections.singletonList(this.unescapeConstantName(ctx.constantName.getText())));
        return this.buildFieldReferenceText(reference);
    }

    @Override
    public String visitNullLiteral(ExpressionParser.NullLiteralContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitNumberLiteral(ExpressionParser.NumberLiteralContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitStringLiteral(ExpressionParser.StringLiteralContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitBooleanLiteral(ExpressionParser.BooleanLiteralContext ctx) {
        return ctx.getText();
    }

    private String buildFieldReferenceText(FieldReference reference) {
        return "${" + this.fieldIdResolver.apply(reference) + "}";
    }

    private String unescapePathElement(String s) {
        return EscapeUtil.unescape(s);
    }

    private String unescapeConstantName(String s) {
        return EscapeUtil.unescape(s);
    }
}

