/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.model.deployment.update;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import org.qubership.integration.platform.catalog.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.runtime.catalog.model.deployment.update.DeploymentConfiguration;

@Schema(description="Single deployment update object")
public class DeploymentUpdate {
    @Schema(description="Information about particular deployment applied on engine pod")
    private DeploymentInfo deploymentInfo;
    @Schema(description="Main chain deployment configuration data")
    private DeploymentConfiguration configuration;
    @Schema(description="List of masked fields")
    private Set<String> maskedFields;

    public static DeploymentUpdateBuilder builder() {
        return new DeploymentUpdateBuilder();
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public DeploymentConfiguration getConfiguration() {
        return this.configuration;
    }

    public Set<String> getMaskedFields() {
        return this.maskedFields;
    }

    public void setDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    public void setConfiguration(DeploymentConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setMaskedFields(Set<String> maskedFields) {
        this.maskedFields = maskedFields;
    }

    public DeploymentUpdate() {
    }

    public DeploymentUpdate(DeploymentInfo deploymentInfo, DeploymentConfiguration configuration, Set<String> maskedFields) {
        this.deploymentInfo = deploymentInfo;
        this.configuration = configuration;
        this.maskedFields = maskedFields;
    }

    public static class DeploymentUpdateBuilder {
        private DeploymentInfo deploymentInfo;
        private DeploymentConfiguration configuration;
        private Set<String> maskedFields;

        DeploymentUpdateBuilder() {
        }

        public DeploymentUpdateBuilder deploymentInfo(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
            return this;
        }

        public DeploymentUpdateBuilder configuration(DeploymentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public DeploymentUpdateBuilder maskedFields(Set<String> maskedFields) {
            this.maskedFields = maskedFields;
            return this;
        }

        public DeploymentUpdate build() {
            return new DeploymentUpdate(this.deploymentInfo, this.configuration, this.maskedFields);
        }

        public String toString() {
            return "DeploymentUpdate.DeploymentUpdateBuilder(deploymentInfo=" + String.valueOf(this.deploymentInfo) + ", configuration=" + String.valueOf(this.configuration) + ", maskedFields=" + String.valueOf(this.maskedFields) + ")";
        }
    }
}

