/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.persistence.configs.repository;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.SnapshotBaseRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

@Repository
public interface SnapshotRepository
extends SnapshotBaseRepository {
    @Query(nativeQuery=true, value="DELETE FROM {h-schema}snapshots where ctid in\n(SELECT s.ctid\nFROM {h-schema}snapshots s\nLEFT JOIN {h-schema}deployments d ON d.snapshot_id = s.id\nLEFT JOIN {h-schema}chains c ON c.current_snapshot_id = s.id\nWHERE s.created_when < :createdWhen AND\nd.id IS NULL AND c.id IS NULL\nLIMIT :chunk) RETURNING id, name, chain_id as chain")
    public List<Map<String, String>> pruneByCreatedWhen(@NonNull Timestamp var1, int var2);

    public List<Snapshot> findAllByChainId(String var1);

    public Optional<Snapshot> findFirstByChainOrderByIdDesc(Chain var1);

    public void deleteAllByChainId(String var1);

    @Query(nativeQuery=true, value="select 'V' || (max(val) + 1)\nFROM (\n    select num as val\n    from (\n        select CAST(replace(name, 'V', '') AS INTEGER) num\n        from {h-schema}snapshots\n        where chain_id = :chainId\n          and name ~ 'V[0-9]+$'\n        order by CAST(replace(name, 'V', '')AS INTEGER) desc\n        LIMIT 1\n    ) t2\n    union all\n    select count(name) as val\n    from {h-schema}snapshots as t1\n    where chain_id = :chainId\n) t")
    public String getNextAvailableName(String var1);

    public Optional<Snapshot> findSnapshotByChainAndName(Chain var1, String var2);

    @Query(value="        SELECT s.*\n        FROM (SELECT chain_id as chain_id, id as snapshot_id, row_number() over(partition by chain_id order by created_when desc) as rn\n              FROM catalog.snapshots) AS rns LEFT JOIN catalog.snapshots s ON s.id = rns.snapshot_id\n        WHERE rns.chain_id IN (:chainIds) AND rn = 1\n", nativeQuery=true)
    public List<Snapshot> findAllLastCreated(Collection<String> var1);
}

