/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Objects;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.service.SystemModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/models/{modelId}/dto/jar"})
@Tag(name="compiled-library-controller", description="Compiled Library Controller")
public class CompiledLibraryController {
    private static final Logger log = LoggerFactory.getLogger(CompiledLibraryController.class);
    private final SystemModelService systemModelService;

    @Autowired
    public CompiledLibraryController(SystemModelService systemModelService) {
        this.systemModelService = systemModelService;
    }

    @GetMapping(produces={"application/octet-stream"})
    @Operation(description="Get compiled jar file for the specification")
    public ResponseEntity<Object> getSystemModelJar(@PathVariable @Parameter(description="Specification id") String modelId) {
        log.debug("Request to get jar file for model with id {}", (Object)modelId);
        Pair<byte[], String> pair = this.systemModelService.getCompiledLibrary(modelId);
        return Objects.isNull(pair) ? ResponseEntity.noContent().build() : ExportImportUtils.convertFileToResponse((byte[])((byte[])pair.getFirst()), (String)((String)pair.getSecond()));
    }
}

