/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.qubership.integration.platform.catalog.model.dto.deployment.DeploymentResponse;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.runtime.catalog.model.deployment.RuntimeDeployment;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.DeploymentRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.DeploymentMapper;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.RuntimeDeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/chains/{chainId}/deployments"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="deployment-controller", description="Deployment Controller")
public class DeploymentController {
    private static final Logger log = LoggerFactory.getLogger(DeploymentController.class);
    private final DeploymentService deploymentService;
    private final DeploymentMapper deploymentMapper;
    private final RuntimeDeploymentService runtimeDeploymentService;

    @Autowired
    public DeploymentController(DeploymentService deploymentService, DeploymentMapper deploymentMapper, RuntimeDeploymentService runtimeDeploymentService) {
        this.deploymentService = deploymentService;
        this.deploymentMapper = deploymentMapper;
        this.runtimeDeploymentService = runtimeDeploymentService;
    }

    @GetMapping
    @Operation(description="Get all deployments for specified chain")
    public ResponseEntity<List<DeploymentResponse>> findAllByChainId(@PathVariable @Parameter(description="Chain id") String chainId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find all required deployment states of chain: {}", (Object)chainId);
        }
        List<Deployment> deployments = this.deploymentService.findAllByChainId(chainId);
        List response = deployments.stream().map(deployment -> {
            RuntimeDeployment runtimeState = this.runtimeDeploymentService.getRuntimeDeployment(deployment.getId());
            return this.deploymentMapper.asResponse((Deployment)deployment, runtimeState);
        }).collect(Collectors.toList());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{deploymentId}"})
    @Operation(description="Get particular deployment of the chain")
    public ResponseEntity<DeploymentResponse> findById(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Deployment id") String deploymentId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to find required deployment {} state in chain {}", (Object)chainId, (Object)deploymentId);
        }
        Deployment deployment = this.deploymentService.findById(deploymentId);
        RuntimeDeployment runtimeState = this.runtimeDeploymentService.getRuntimeDeployment(deploymentId);
        DeploymentResponse response = this.deploymentMapper.asResponse(deployment, runtimeState);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    @Operation(description="Create deployment for the chain")
    public ResponseEntity<DeploymentResponse> create(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Valid @Parameter(description="Deployment request object") DeploymentRequest request) {
        log.info("Request to create new deployment in chain: {}", (Object)chainId);
        String snapshotId = request.getSnapshotId();
        Deployment deployment = this.deploymentMapper.asEntity(request);
        deployment = this.deploymentService.create(deployment, chainId, snapshotId);
        DeploymentResponse response = this.deploymentMapper.asResponse(deployment);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/all"})
    @Operation(description="Bulk create deployment for the chain")
    public ResponseEntity<List<DeploymentResponse>> createAll(@PathVariable @Parameter(description="Chain id") String chainId, @RequestBody @Valid @Parameter(description="List of deployment request objects") List<DeploymentRequest> request) {
        log.info("Request to create new deployments in chain: {}", (Object)chainId);
        List<Deployment> deployments = this.deploymentService.createAll(this.deploymentMapper.asEntities(request), chainId);
        return ResponseEntity.ok(this.deploymentMapper.asResponses(deployments));
    }

    @DeleteMapping
    @Operation(description="Delete all deployments for specified chain")
    public ResponseEntity<Void> deleteByChainId(@PathVariable @Parameter(description="Chain id") String chainId) {
        log.info("Request to delete all deployments of chain: {}", (Object)chainId);
        this.deploymentService.deleteAllByChainId(chainId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @DeleteMapping(value={"/{deploymentId}"})
    @Operation(description="Delete specific deployment for the chain")
    public ResponseEntity<?> deleteById(@PathVariable @Parameter(description="Chain id") String chainId, @PathVariable @Parameter(description="Deployment id") String deploymentId) {
        log.info("Request to delete deployment {} from chain {}", (Object)deploymentId, (Object)chainId);
        this.deploymentService.deleteById(deploymentId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

