/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationState;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationStatus;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationAlertsSet;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.DiagnosticValidationDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.DiagnosticValidationFilterDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.ValidationStatusDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.DiagnosticValidationMapper;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.DiagnosticService;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.AbstractValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/diagnostic"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="diagnostic-controller", description="Diagnostic Controller")
public class DiagnosticController {
    private static final Logger log = LoggerFactory.getLogger(DiagnosticController.class);
    private final DiagnosticService diagnosticService;
    private final DiagnosticValidationMapper validationMapper;

    @Autowired
    public DiagnosticController(DiagnosticService diagnosticService, DiagnosticValidationMapper validationMapper) {
        this.diagnosticService = diagnosticService;
        this.validationMapper = validationMapper;
    }

    @PostMapping(value={"/validations"})
    @Operation(description="Search diagnostic validations")
    public ResponseEntity<List<DiagnosticValidationDTO>> searchValidations(@RequestBody(required=false) @Parameter(description="Validation search request object") DiagnosticValidationFilterDTO filterRequest) {
        if (log.isDebugEnabled()) {
            log.debug("Request to search diagnostic validations");
        }
        List<Pair<AbstractValidation, ValidationAlertsSet>> validations = this.diagnosticService.getFilteredValidations(filterRequest);
        Map<String, ValidationStatus> statuses = this.diagnosticService.getCurrentStatuses();
        ArrayList<DiagnosticValidationDTO> result = new ArrayList<DiagnosticValidationDTO>(validations.size());
        for (Pair<AbstractValidation, ValidationAlertsSet> pair : validations) {
            AbstractValidation validation = (AbstractValidation)pair.getLeft();
            ValidationAlertsSet alertsSet = (ValidationAlertsSet)pair.getRight();
            ValidationStatusDTO statusDTO = this.validationMapper.asStatusDTO(statuses.get(validation.getId()));
            result.add(this.validationMapper.asDTO(validation, statusDTO, alertsSet));
        }
        for (DiagnosticValidationDTO dto : result) {
            DiagnosticController.clearEntitiesByState(dto);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/validations/{validationId}"})
    @Operation(description="Get diagnostic validations by id")
    public ResponseEntity<DiagnosticValidationDTO> getValidationById(@PathVariable(value="validationId") @Parameter(description="Validation id") String validationId) {
        if (log.isDebugEnabled()) {
            log.debug("Request to get all diagnostic validation: {}", (Object)validationId);
        }
        Pair<AbstractValidation, ValidationAlertsSet> pair = this.diagnosticService.getValidationById(validationId);
        ValidationStatusDTO status = this.validationMapper.asStatusDTO(this.diagnosticService.getCurrentStatus(validationId));
        ValidationAlertsSet alertsSet = (ValidationAlertsSet)pair.getRight();
        DiagnosticValidationDTO dto = this.validationMapper.asDTO((AbstractValidation)pair.getLeft(), status, alertsSet);
        DiagnosticController.clearEntitiesByState(dto);
        return ResponseEntity.ok((Object)dto);
    }

    @PatchMapping(value={"/validations"})
    @Operation(description="Run diagnostic validations")
    public ResponseEntity<Void> runValidations(@RequestParam(required=false, defaultValue="") @Parameter(description="List of validation IDs that need to be run. If the parameter is empty, then all validations will be run") Set<String> validationIds) {
        log.info("Request to start validations processing for: {}", validationIds == null || validationIds.isEmpty() ? "all validations" : validationIds);
        this.diagnosticService.runValidationsAsync(validationIds);
        return ResponseEntity.accepted().build();
    }

    private static void clearEntitiesByState(DiagnosticValidationDTO dto) {
        if (dto.getStatus().getState() == ValidationState.FAILED || dto.getStatus().getState() == ValidationState.IN_PROGRESS || dto.getStatus().getState() == ValidationState.NOT_STARTED) {
            dto.setAlertsCount(0L);
            dto.setChainEntities(dto.getChainEntities() == null ? null : Collections.emptyList());
        }
    }
}

