/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import org.qubership.integration.platform.catalog.model.apispec.ApiSpecificationFormat;
import org.qubership.integration.platform.catalog.model.apispec.ApiSpecificationType;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ApiSpecificationExportService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/v1/catalog/export"}, produces={"application/octet-stream"})
@CrossOrigin(origins={"*"})
@Tag(name="export-controller", description="Export Controller")
public class ExportController {
    private static final Logger log = LoggerFactory.getLogger(ExportController.class);
    private final ExportService exportService;
    private final ApiSpecificationExportService apiSpecificationExportService;

    @Autowired
    public ExportController(ExportService exportService, ApiSpecificationExportService apiSpecificationExportService) {
        this.exportService = exportService;
        this.apiSpecificationExportService = apiSpecificationExportService;
    }

    @GetMapping(value={"/chain/{chainId}"})
    @Operation(description="Export chain as a zip archive")
    public ResponseEntity<Object> exportChain(@PathVariable @NotBlank @Parameter(description="Chain id") String chainId) {
        log.info("Request to export chain with id: {}", (Object)chainId);
        Pair<String, byte[]> zip = this.exportService.exportSingleChain(chainId);
        return this.asResponse(zip);
    }

    @GetMapping(value={"/chains"})
    @Operation(description="Export multiple chains in a single zip archive")
    public ResponseEntity<Object> exportChains(@RequestParam @NotEmpty @Valid @Parameter(description="List of chain ids, separated by comma") List<String> chainIds, @RequestParam(required=false) @Parameter(description="Whether resulting archive should contain sub-chains called from specified chains") boolean exportWithSubChains) {
        log.info("Request to export chains with IDs: {}", chainIds);
        Pair<String, byte[]> zip = this.exportService.exportListChains(chainIds, exportWithSubChains);
        return this.asResponse(zip);
    }

    @GetMapping
    @Operation(description="Export all available chains in a single zip archive")
    public ResponseEntity<Object> exportAllChains() {
        log.info("Request to export all chain");
        Pair<String, byte[]> zip = this.exportService.exportAllChains();
        return this.asResponse(zip);
    }

    @GetMapping(value={"/api-spec"})
    @Operation(description="Generate API specification")
    public ResponseEntity<Object> exportSpecification(@RequestParam(required=false, defaultValue="") @Parameter(description="List of deployment ids") List<String> deploymentIds, @RequestParam(required=false, defaultValue="") @Parameter(description="List of snapshot ids") List<String> snapshotIds, @RequestParam(required=false, defaultValue="") @Parameter(description="List of chain ids") List<String> chainIds, @RequestParam(required=false, defaultValue="") @Parameter(description="List of http trigger element ids") List<String> httpTriggerIds, @RequestParam(required=false, defaultValue="true") @Parameter(description="Whether external routes should be included") boolean externalRoutes, @RequestParam(required=false, defaultValue="OpenAPI") @Parameter(description="Specification type") ApiSpecificationType specificationType, @RequestParam(required=false, defaultValue="YAML") @Parameter(description="Specification format") ApiSpecificationFormat format) {
        log.info("Request to export {} specification for {} routes from deployments {}, snapshots {}, and chains {}", new Object[]{specificationType, externalRoutes ? "external" : "", deploymentIds, snapshotIds, chainIds});
        Pair<String, byte[]> spec = this.apiSpecificationExportService.exportApiSpecification(deploymentIds, snapshotIds, chainIds, httpTriggerIds, externalRoutes, specificationType, format);
        return this.asResponse(spec);
    }

    private ResponseEntity<Object> asResponse(Pair<String, byte[]> zip) {
        HttpHeaders header = new HttpHeaders();
        header.add("Content-Disposition", "attachment; filename=\"" + (String)zip.getFirst() + "\"");
        header.add("Access-Control-Expose-Headers", "Content-Disposition");
        ByteArrayResource resource = new ByteArrayResource((byte[])zip.getSecond());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(header)).contentLength(resource.contentLength()).body((Object)resource);
    }
}

