/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.bulk;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.bulk.BulkDeploymentSnapshotAction;

@Schema(description="Chain bulk deploy request object")
public class BulkDeploymentRequest {
    @Schema(description="List of domains to deploy to (usually \"default\")")
    private List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> domains;
    @Schema(description="Which snapshot should be taken during bulk deploy")
    private BulkDeploymentSnapshotAction snapshotAction;
    @Schema(description="List of id of chains which should be (re)deployed")
    private List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> chainIds;

    private static BulkDeploymentSnapshotAction $default$snapshotAction() {
        return BulkDeploymentSnapshotAction.CREATE_NEW;
    }

    private static List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> $default$chainIds() {
        return new ArrayList<String>();
    }

    public static BulkDeploymentRequestBuilder builder() {
        return new BulkDeploymentRequestBuilder();
    }

    public List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> getDomains() {
        return this.domains;
    }

    public BulkDeploymentSnapshotAction getSnapshotAction() {
        return this.snapshotAction;
    }

    public List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> getChainIds() {
        return this.chainIds;
    }

    public void setDomains(List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> domains) {
        this.domains = domains;
    }

    public void setSnapshotAction(BulkDeploymentSnapshotAction snapshotAction) {
        this.snapshotAction = snapshotAction;
    }

    public void setChainIds(List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> chainIds) {
        this.chainIds = chainIds;
    }

    public BulkDeploymentRequest() {
        this.snapshotAction = BulkDeploymentRequest.$default$snapshotAction();
        this.chainIds = BulkDeploymentRequest.$default$chainIds();
    }

    public BulkDeploymentRequest(List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> domains, BulkDeploymentSnapshotAction snapshotAction, List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> chainIds) {
        this.domains = domains;
        this.snapshotAction = snapshotAction;
        this.chainIds = chainIds;
    }

    public static class BulkDeploymentRequestBuilder {
        private List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> domains;
        private boolean snapshotAction$set;
        private BulkDeploymentSnapshotAction snapshotAction$value;
        private boolean chainIds$set;
        private List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> chainIds$value;

        BulkDeploymentRequestBuilder() {
        }

        public BulkDeploymentRequestBuilder domains(List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> domains) {
            this.domains = domains;
            return this;
        }

        public BulkDeploymentRequestBuilder snapshotAction(BulkDeploymentSnapshotAction snapshotAction) {
            this.snapshotAction$value = snapshotAction;
            this.snapshotAction$set = true;
            return this;
        }

        public BulkDeploymentRequestBuilder chainIds(List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> chainIds) {
            this.chainIds$value = chainIds;
            this.chainIds$set = true;
            return this;
        }

        public BulkDeploymentRequest build() {
            BulkDeploymentSnapshotAction snapshotAction$value = this.snapshotAction$value;
            if (!this.snapshotAction$set) {
                snapshotAction$value = BulkDeploymentRequest.$default$snapshotAction();
            }
            List<@NotBlank @Pattern(regexp="^[-._a-zA-Z0-9]+$") String> chainIds$value = this.chainIds$value;
            if (!this.chainIds$set) {
                chainIds$value = BulkDeploymentRequest.$default$chainIds();
            }
            return new BulkDeploymentRequest(this.domains, snapshotAction$value, chainIds$value);
        }

        public String toString() {
            return "BulkDeploymentRequest.BulkDeploymentRequestBuilder(domains=" + String.valueOf(this.domains) + ", snapshotAction$value=" + String.valueOf((Object)this.snapshotAction$value) + ", chainIds$value=" + String.valueOf(this.chainIds$value) + ")";
        }
    }
}

