/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v2.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import org.qubership.integration.platform.runtime.catalog.service.SnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/catalog/snapshots"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
public class SnapshotControllerV2 {
    private static final Logger log = LoggerFactory.getLogger(SnapshotControllerV2.class);
    private final SnapshotService snapshotService;

    @Autowired
    public SnapshotControllerV2(SnapshotService snapshotService) {
        this.snapshotService = snapshotService;
    }

    @PostMapping(value={"/bulk-delete"})
    @Operation(description="Bulk delete snapshots")
    public ResponseEntity<Void> bulkDeleteSnapshots(@RequestBody @Parameter(description="List of snapshots' IDs") List<String> snapshotIds) {
        log.info("Request to delete snapshots: {}", snapshotIds);
        snapshotIds.forEach(snapshotId -> {
            try {
                this.snapshotService.deleteById((String)snapshotId);
            }
            catch (EntityNotFoundException e) {
                log.warn("Snapshot not found: {}", snapshotId);
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

