/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.consul.exception.KVNotFoundException;
import org.qubership.integration.platform.catalog.model.deployment.engine.ChainRuntimeDeployment;
import org.qubership.integration.platform.catalog.model.deployment.engine.DeploymentStatus;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineInfo;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineState;
import org.qubership.integration.platform.catalog.persistence.TransactionHandler;
import org.qubership.integration.platform.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.runtime.catalog.events.EngineStateUpdateEvent;
import org.qubership.integration.platform.runtime.catalog.model.deployment.RuntimeDeployment;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.repository.DeploymentRepository;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.DeploymentMapper;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class RuntimeDeploymentService {
    private static final Logger log = LoggerFactory.getLogger(RuntimeDeploymentService.class);
    private final TransactionHandler transactionHandler;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final DeploymentRepository deploymentRepository;
    private final DeploymentMapper deploymentMapper;
    private final AtomicReference<Map<String, EngineState>> enginesStateCache = new AtomicReference(new HashMap());

    @Autowired
    public RuntimeDeploymentService(TransactionHandler transactionHandler, ApplicationEventPublisher applicationEventPublisher, DeploymentRepository deploymentRepository, @Lazy DeploymentMapper deploymentMapper) {
        this.transactionHandler = transactionHandler;
        this.applicationEventPublisher = applicationEventPublisher;
        this.deploymentRepository = deploymentRepository;
        this.deploymentMapper = deploymentMapper;
    }

    public Map<String, Collection<ChainRuntimeDeployment>> getChainRuntimeDeployments() {
        HashMap<String, Collection<ChainRuntimeDeployment>> result = new HashMap<String, Collection<ChainRuntimeDeployment>>();
        Collection<EngineState> states = this.enginesStateCache.get().values();
        for (EngineState engineState : states) {
            Map deployments = engineState.getDeployments();
            if (deployments == null) continue;
            for (EngineDeployment engineDeployment : deployments.values()) {
                result.computeIfAbsent(engineDeployment.getDeploymentInfo().getChainId(), k -> new ArrayList()).add(this.deploymentMapper.toChainRuntimeDeployment(engineDeployment, engineState.getEngine().getHost()));
            }
        }
        return result;
    }

    public Collection<EngineDeployment> findRuntimeDeployments(String engineHost) {
        try {
            Map<String, EngineState> states = this.enginesStateCache.get();
            if (states.containsKey(engineHost)) {
                return states.get(engineHost).getDeployments().values();
            }
        }
        catch (KVNotFoundException kvnfe) {
            log.warn("Engines state KV is empty. {}", (Object)kvnfe.getMessage());
        }
        return Collections.emptyList();
    }

    public Map<String, List<String>> getEngineHosts() {
        List<EngineState> engineStates = this.enginesStateCache.get().values().stream().toList();
        HashMap<String, List<String>> hosts = new HashMap<String, List<String>>();
        for (EngineState engineState : engineStates) {
            if (hosts.get(engineState.getEngine().getDomain()) != null) {
                ((List)hosts.get(engineState.getEngine().getDomain())).add(engineState.getEngine().getHost());
                continue;
            }
            hosts.put(engineState.getEngine().getDomain(), new ArrayList<String>(Collections.singletonList(engineState.getEngine().getHost())));
        }
        return hosts;
    }

    public RuntimeDeployment getRuntimeDeployment(String deploymentId) {
        RuntimeDeployment runtimeDeployment = new RuntimeDeployment(deploymentId);
        Collection<EngineState> states = this.enginesStateCache.get().values();
        for (EngineState engineState : states) {
            runtimeDeployment.setServiceName(engineState.getEngine().getEngineDeploymentName());
            runtimeDeployment.getStates().put(engineState.getEngine().getHost(), Optional.ofNullable(engineState.getDeployments()).map(deployments -> (EngineDeployment)deployments.get(deploymentId)).orElse(null));
        }
        return runtimeDeployment;
    }

    public void provideEnginesStateUpdate(Collection<EngineState> newStateList) {
        Map<String, EngineState> stateMap = RuntimeDeploymentService.remapEngineStatesForCache(newStateList);
        Map<String, Pair<EngineInfo, EngineDeployment>> newState = this.remapEngineStatesForCompare(stateMap);
        Map<String, Pair<EngineInfo, EngineDeployment>> oldState = this.remapEngineStatesForCompare(this.enginesStateCache.getAndSet(stateMap));
        ArrayList<Pair<EngineInfo, EngineDeployment>> deploymentsDelta = new ArrayList<Pair<EngineInfo, EngineDeployment>>();
        Set<String> newStateKeys = newState.keySet();
        Set<String> oldStateKeys = oldState.keySet();
        HashSet<String> removed = new HashSet<String>(oldStateKeys);
        removed.removeAll(newStateKeys);
        for (String string : removed) {
            Pair<EngineInfo, EngineDeployment> pair = oldState.get(string);
            ((EngineDeployment)pair.getRight()).setStatus(DeploymentStatus.REMOVED);
            deploymentsDelta.add(pair);
        }
        HashSet<String> added = new HashSet<String>(newStateKeys);
        added.removeAll(oldStateKeys);
        for (String string : added) {
            deploymentsDelta.add(newState.get(string));
        }
        HashSet<String> hashSet = new HashSet<String>(newStateKeys);
        hashSet.retainAll(oldStateKeys);
        for (String string : hashSet) {
            Pair<EngineInfo, EngineDeployment> newPair = newState.get(string);
            Pair<EngineInfo, EngineDeployment> oldPair = oldState.get(string);
            if (((EngineDeployment)oldPair.getRight()).getStatus() == ((EngineDeployment)newPair.getRight()).getStatus()) continue;
            deploymentsDelta.add(newPair);
        }
        for (Pair pair : deploymentsDelta) {
            String userId = null;
            Optional deploymentOptional = this.deploymentRepository.findById(((EngineDeployment)pair.getRight()).getDeploymentInfo().getDeploymentId());
            if (deploymentOptional.isPresent()) {
                User createdBy = ((Deployment)deploymentOptional.get()).getCreatedBy();
                userId = createdBy == null ? null : createdBy.getId();
            }
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new EngineStateUpdateEvent(this, (EngineInfo)pair.getLeft(), (EngineDeployment)pair.getRight(), new DeploymentService.LoggingInfo(deploymentOptional), userId, null));
        }
        HashMap hashMap = new HashMap();
        for (EngineState report : newStateList) {
            hashMap.putAll(report.getDeployments());
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> notDeployed = new HashSet<String>();
        for (Map.Entry entry : hashMap.entrySet()) {
            switch (((EngineDeployment)entry.getValue()).getStatus()) {
                case DEPLOYED: {
                    hashSet2.add((String)entry.getKey());
                    break;
                }
                case PROCESSING: 
                case FAILED: {
                    notDeployed.add((String)entry.getKey());
                }
            }
        }
        this.transactionHandler.runInTransaction(() -> this.deploymentRepository.deleteObsoleteDeployments(deployed, notDeployed));
    }

    private Map<String, Pair<EngineInfo, EngineDeployment>> remapEngineStatesForCompare(Map<String, EngineState> stateMap) {
        HashMap<String, Pair<EngineInfo, EngineDeployment>> result = new HashMap<String, Pair<EngineInfo, EngineDeployment>>();
        for (EngineState state : stateMap.values()) {
            EngineInfo engine = state.getEngine();
            String host = engine.getHost();
            for (Map.Entry deploymentEntry : state.getDeployments().entrySet()) {
                EngineDeployment deployment = (EngineDeployment)deploymentEntry.getValue();
                String deploymentId = deployment.getDeploymentInfo().getDeploymentId();
                result.put(host + deploymentId, (Pair<EngineInfo, EngineDeployment>)Pair.of((Object)engine, (Object)deployment));
            }
        }
        return result;
    }

    @NotNull
    private static Map<String, EngineState> remapEngineStatesForCache(Collection<EngineState> newState) {
        return newState.stream().collect(Collectors.toMap(state -> state.getEngine().getHost(), Function.identity(), (s1, s2) -> s1));
    }
}

