/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.exception.SpecificationImportException;
import org.qubership.integration.platform.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SpecificationGroupLabelsRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SpecificationGroupRepository;
import org.qubership.integration.platform.catalog.service.AbstractSpecificationGroupService;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.exportimport.ProtocolExtractionService;
import org.qubership.integration.platform.catalog.util.MultipartFileUtils;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SpecificationGroupService
extends AbstractSpecificationGroupService {
    private static final Logger log = LoggerFactory.getLogger(SpecificationGroupService.class);
    private final SystemService systemService;
    private final ProtocolExtractionService protocolExtractionService;
    private final ChainService chainService;

    @Autowired
    public SpecificationGroupService(SpecificationGroupRepository specificationGroupRepository, ActionsLogService actionLogger, SystemService systemService, ProtocolExtractionService protocolExtractionService, SpecificationGroupLabelsRepository specificationGroupLabelsRepository, ChainService chainService) {
        super(specificationGroupRepository, actionLogger, specificationGroupLabelsRepository);
        this.systemService = systemService;
        this.protocolExtractionService = protocolExtractionService;
        this.chainService = chainService;
    }

    public SpecificationGroup createAndSaveSpecificationGroupWithProtocol(IntegrationSystem system, String specificationName, String protocol, MultipartFile[] files, String specificationUrl) {
        if (system == null) {
            throw new SpecificationImportException("Can't find system with given id");
        }
        if (this.specificationGroupRepository.findByNameAndSystem(specificationName, system) != null) {
            throw new SpecificationImportException("Specification group name is not unique");
        }
        this.setSystemProtocol(system, protocol, files);
        SpecificationGroup specificationGroup = new SpecificationGroup();
        specificationGroup.setId(this.buildSpecificationGroupId(system, specificationName));
        specificationGroup.setName(specificationName);
        specificationGroup.setUrl(specificationUrl);
        specificationGroup = (SpecificationGroup)this.specificationGroupRepository.save((Object)specificationGroup);
        system.addSpecificationGroup(specificationGroup);
        this.systemService.update(system, false);
        this.logSpecGroupAction(specificationGroup, system, LogOperation.CREATE);
        return specificationGroup;
    }

    public SpecificationGroup createAndSaveSpecificationGroup(String systemId, String specificationName, String protocol, MultipartFile[] files) {
        return this.createAndSaveSpecificationGroupWithProtocol(this.systemService.getByIdOrNull(systemId), specificationName, protocol, files, null);
    }

    public Optional<SpecificationGroup> deleteByIdExists(String specificationGroupId) {
        Optional specificationGroupOptional = this.specificationGroupRepository.findById((Object)specificationGroupId);
        if (specificationGroupOptional.isPresent()) {
            if (this.chainService.isSpecificationGroupUsedByChain(specificationGroupId)) {
                throw new IllegalArgumentException("Specification group used by one or more chains");
            }
            SpecificationGroup specificationGroup = (SpecificationGroup)specificationGroupOptional.get();
            this.specificationGroupRepository.delete((Object)specificationGroup);
            this.logSpecGroupAction(specificationGroup, specificationGroup.getSystem(), LogOperation.DELETE);
            return Optional.of(specificationGroup);
        }
        return Optional.empty();
    }

    private void setSystemProtocol(IntegrationSystem system, String protocol, MultipartFile[] files) {
        try {
            if (system.getProtocol() == null) {
                OperationProtocol operationProtocol = StringUtils.isBlank((CharSequence)protocol) ? this.protocolExtractionService.getOperationProtocol(MultipartFileUtils.extractArchives((MultipartFile[])files)) : OperationProtocol.fromValue((String)protocol);
                if (Objects.isNull(operationProtocol)) {
                    throw new SpecificationImportException("Unsupported protocol: " + protocol);
                }
                this.systemService.validateSpecificationProtocol(system, operationProtocol);
                system.setProtocol(operationProtocol);
            } else {
                OperationProtocol operationProtocol = this.protocolExtractionService.getOperationProtocol(MultipartFileUtils.extractArchives((MultipartFile[])files));
                if (operationProtocol != null && !system.getProtocol().equals((Object)operationProtocol)) {
                    throw new SpecificationImportException("Protocol of provided specification doesn't match with a system protocol");
                }
            }
        }
        catch (IOException exception) {
            throw new SpecificationImportException("Input file is invalid", (Exception)exception);
        }
    }
}

