/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.persistence.configs.repository.diagnostic.ElementValidationRepository;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationImplementationType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationEntityType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin.BuiltinValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SubChainNotUsedValidation
extends BuiltinValidation {
    private static final Logger log = LoggerFactory.getLogger(SubChainNotUsedValidation.class);
    private static final String MIN_USAGE_COUNT_KEY = "minUsageCount";
    private final ElementValidationRepository elementRepository;

    public SubChainNotUsedValidation(ElementValidationRepository elementRepository) {
        super("sub-chain-not-used_4NIY0ODV", "Sub-chain is used by single chain or not used at all", "Rule allows to find chains which were not used in other chains, or they were used only once.", "Sub-chains are designed to handle frequent and common scenarios and are expected to be linked with large numbers of chains. Verify that sub-chains are properly linked to all chains, where they are supposed to be used. Consider including sub-chain logic into the main chain if only this chain uses it.", ValidationEntityType.CHAIN_ELEMENT, ValidationImplementationType.BUILT_IN, ValidationSeverity.ERROR);
        this.elementRepository = elementRepository;
        this.putProperty(MIN_USAGE_COUNT_KEY, Integer.valueOf(2));
    }

    public Collection<ValidationChainAlert> validate() throws DiagnosticValidationUnexpectedException {
        try {
            return this.processValidation();
        }
        catch (Exception e) {
            throw new DiagnosticValidationUnexpectedException("Validation failed with an unexpected error: " + e.getMessage(), e);
        }
    }

    @NotNull
    private List<ValidationChainAlert> processValidation() {
        List containsScriptElements = this.elementRepository.findAllForSubChainNotUsedValidation((Integer)this.getProperty(MIN_USAGE_COUNT_KEY));
        return containsScriptElements.stream().map(element -> ValidationChainAlert.builder().validationId(this.getId()).chain(element.getChain()).element(element).build()).toList();
    }
}

