/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import jakarta.persistence.EntityNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.ElementRoute;
import org.qubership.integration.platform.catalog.model.apispec.ApiSpecificationFormat;
import org.qubership.integration.platform.catalog.model.apispec.ApiSpecificationType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.operations.OperationRepository;
import org.qubership.integration.platform.catalog.util.TriggerUtils;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ApiSpecificationExportException;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.HttpTriggerMethodsNotSpecified;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.WrongChainElementTypeException;
import org.qubership.integration.platform.runtime.catalog.service.SystemModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class ApiSpecificationExportService {
    private static final Logger log = LoggerFactory.getLogger(ApiSpecificationExportService.class);
    private static final String INTERNAL_ROUTES_BASE_PATH = "/routes";
    private static final String OPERATION_WITH_ID_NOT_FOUND_MESSAGE = "Can't find operation with id ";
    private final String externalRoutesBasePath;
    private final ElementRepository elementRepository;
    private final OperationRepository operationRepository;
    private final SystemModelService systemModelService;

    @Autowired
    public ApiSpecificationExportService(@Value(value="${qip.chains.external-routes.base-path:/qip-routes}") String externalRoutesBasePath, ElementRepository elementRepository, OperationRepository operationRepository, SystemModelService systemModelService) {
        this.externalRoutesBasePath = !externalRoutesBasePath.startsWith("/") ? "/" + externalRoutesBasePath : externalRoutesBasePath;
        this.elementRepository = elementRepository;
        this.operationRepository = operationRepository;
        this.systemModelService = systemModelService;
    }

    public Pair<String, byte[]> exportApiSpecification(Collection<String> deploymentIds, Collection<String> snapshotIds, Collection<String> chainIds, Collection<String> httpTriggerIds, boolean externalRoutes, ApiSpecificationType apiSpecificationType, ApiSpecificationFormat apiSpecificationFormat) {
        Collection<ChainElement> elements = this.getTriggerElements(deploymentIds, snapshotIds, chainIds, httpTriggerIds, externalRoutes, apiSpecificationType);
        SpecificationBuildParameters buildParameters = SpecificationBuildParameters.builder().elements(elements).externalRoutes(externalRoutes).build();
        Object apiSpecification = this.buildApiSpecification(apiSpecificationType, buildParameters);
        String specificationText = this.serializeApiSpecification(apiSpecification, apiSpecificationFormat);
        String specificationFileName = this.getSpecificationFileName(apiSpecificationType, apiSpecificationFormat);
        return Pair.of((Object)specificationFileName, (Object)specificationText.getBytes());
    }

    private Collection<ChainElement> getTriggerElements(Collection<String> deploymentIds, Collection<String> snapshotIds, Collection<String> chainIds, Collection<String> httpTriggerIds, boolean externalRoutes, ApiSpecificationType apiSpecificationType) {
        Collection<String> triggerTypes = this.getTriggerTypes(apiSpecificationType);
        Predicate<ChainElement> elementFilterPredicate = this.getElementFilterPredicate(apiSpecificationType, externalRoutes);
        if (!chainIds.isEmpty()) {
            elementFilterPredicate = elementFilterPredicate.and(element -> httpTriggerIds.contains(element.getId()));
        }
        Stream elementStream = deploymentIds.isEmpty() && snapshotIds.isEmpty() && chainIds.isEmpty() ? this.elementRepository.findAllDeployedElementsByTypes(triggerTypes).stream() : Stream.of(this.elementRepository.findElementsByTypesAndDeployments(triggerTypes, deploymentIds), this.elementRepository.findElementsByTypesAndSnapshots(triggerTypes, snapshotIds), this.elementRepository.findElementsByTypesAndChains(triggerTypes, chainIds)).flatMap(Collection::stream);
        return elementStream.filter(elementFilterPredicate).collect(Collectors.toList());
    }

    private Collection<String> getTriggerTypes(ApiSpecificationType apiSpecificationType) {
        switch (apiSpecificationType) {
            case AsyncAPI: {
                return TriggerUtils.getAsyncTriggerTypeNames();
            }
            case OpenAPI: {
                return Collections.singletonList(TriggerUtils.getHttpTriggerTypeName());
            }
        }
        return Collections.emptyList();
    }

    private Predicate<ChainElement> getElementFilterPredicate(ApiSpecificationType apiSpecificationType, boolean externalRoutes) {
        switch (apiSpecificationType) {
            case OpenAPI: {
                return element -> !externalRoutes || TriggerUtils.getHttpTriggerRoute((ChainElement)element).isExternal();
            }
        }
        return element -> true;
    }

    private String getSpecificationFileName(ApiSpecificationType apiSpecificationType, ApiSpecificationFormat format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
        String formatPostfix = this.getFileNamePostfix(format);
        return "export-" + apiSpecificationType.name().toLowerCase() + "-specification-" + dateFormat.format(new Date()) + formatPostfix;
    }

    private String getFileNamePostfix(ApiSpecificationFormat format) {
        switch (format) {
            case YAML: {
                return ".yaml";
            }
            case JSON: {
                return ".json";
            }
        }
        return "";
    }

    private Object buildApiSpecification(ApiSpecificationType apiSpecificationType, SpecificationBuildParameters buildParameters) {
        return this.getSpecificationBuilder(apiSpecificationType).apply(buildParameters);
    }

    private Function<SpecificationBuildParameters, Object> getSpecificationBuilder(ApiSpecificationType apiSpecificationType) {
        switch (apiSpecificationType) {
            case OpenAPI: {
                return this::buildOpenApiSpecification;
            }
            case AsyncAPI: {
                return this::buildAsyncApiSpecification;
            }
        }
        throw new ApiSpecificationExportException("Unsupported specification type: " + apiSpecificationType.name());
    }

    private String serializeApiSpecification(Object specification, ApiSpecificationFormat format) {
        ObjectMapper mapper = this.getSpecificationMapper(format);
        try {
            return mapper.writeValueAsString(specification);
        }
        catch (JsonProcessingException exception) {
            throw new ApiSpecificationExportException("Failed to export API specification", (Exception)((Object)exception));
        }
    }

    private ObjectMapper getSpecificationMapper(ApiSpecificationFormat format) {
        switch (format) {
            case YAML: {
                return Yaml.mapper();
            }
            case JSON: {
                return Json.mapper();
            }
        }
        throw new ApiSpecificationExportException("Unsupported specification format: " + format.name());
    }

    private Object buildOpenApiSpecification(SpecificationBuildParameters buildParameters) {
        return new OpenAPI().info(this.buildSpecificationInfo(buildParameters.getElements())).paths(this.buildPaths(buildParameters.getElements())).servers(this.buildServers(buildParameters.isExternalRoutes())).components(this.buildComponents(buildParameters.getElements()));
    }

    private List<Server> buildServers(boolean externalRoutes) {
        Server server = new Server();
        String basePath = externalRoutes ? this.externalRoutesBasePath : INTERNAL_ROUTES_BASE_PATH;
        server.url("{basePath}").variables(new ServerVariables().addServerVariable("basePath", new ServerVariable()._default(basePath)));
        return Collections.singletonList(server);
    }

    private String buildAsyncApiSpecification(SpecificationBuildParameters buildParameters) {
        throw new ApiSpecificationExportException("OpenAPI specification export not implemented yet");
    }

    private Info buildSpecificationInfo(Collection<ChainElement> elements) {
        return new Info().title(this.buildConfigurationTitle()).description(this.buildConfigurationDescription(elements)).version(this.buildConfigurationVersion());
    }

    private String buildConfigurationTitle() {
        return "Exported API specification";
    }

    private String buildConfigurationVersion() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
        return "exported-api-specification-" + dateFormat.format(new Date());
    }

    private String buildConfigurationDescription(Collection<ChainElement> elements) {
        StringBuilder sb = new StringBuilder();
        elements.forEach(element -> {
            sb.append("* ").append(this.getElementChain((ChainElement)element).getName()).append(" - ").append(element.getName());
            if (Objects.nonNull(element.getSnapshot())) {
                sb.append(" (").append(element.getSnapshot().getName()).append(")");
            }
            sb.append("\n");
        });
        return sb.toString();
    }

    private Chain getElementChain(ChainElement element) {
        Chain chain = element.getChain();
        return Objects.isNull(chain) ? element.getSnapshot().getChain() : chain;
    }

    private Paths buildPaths(Collection<ChainElement> elements) {
        Paths paths = new Paths();
        for (ChainElement element : elements) {
            this.verifyElement(element);
            ElementRoute route = TriggerUtils.getHttpTriggerRoute((ChainElement)element);
            PathItem pathItem = (PathItem)paths.computeIfAbsent((Object)("/" + route.getPath()), path -> new PathItem());
            for (HttpMethod method : route.getMethods()) {
                pathItem.operation(this.toOpenApiHttpMethod(method), this.buildOperation(element, route, method));
            }
        }
        return paths;
    }

    private void verifyElement(ChainElement element) {
        if (!TriggerUtils.isHttpTrigger((ChainElement)element)) {
            throw new WrongChainElementTypeException(element, Collections.singletonList(TriggerUtils.getHttpTriggerTypeName()));
        }
        if (!TriggerUtils.areHttpTriggerMethodsSpecified((ChainElement)element)) {
            throw new HttpTriggerMethodsNotSpecified(element);
        }
    }

    private Components buildComponents(Collection<ChainElement> elements) {
        Stream<Components> implementedServiceTriggerComponents = ((Stream)elements.stream().filter(TriggerUtils::isImplementedServiceTrigger).map(TriggerUtils::getImplementedServiceTriggerSpecificationId).distinct().parallel()).map(specificationId -> {
            Components components = this.getSpecification((String)specificationId).getComponents();
            if (Objects.isNull(components)) {
                components = new Components();
            }
            this.updateReferencesForComponents(components, ref -> this.addSuffixToRef((String)ref, (String)specificationId));
            this.updateIdentifiersForComponents(components, (String)specificationId);
            return components;
        });
        Stream<Components> customUriTriggerComponents = ((Stream)elements.stream().filter(TriggerUtils::isCustomUriHttpTrigger).parallel()).map(element -> {
            String validationSchemaText = TriggerUtils.getHttpTriggerValidationSchema((ChainElement)element);
            if (StringUtils.isBlank((CharSequence)validationSchemaText)) {
                return new Components();
            }
            Components components = this.buildComponentsFromValidationSchema(validationSchemaText);
            this.updateReferencesForComponents(components, ref -> this.updateSchemasRefAndAddSuffixToRef((String)ref, element.getId()));
            this.updateIdentifiersForComponents(components, element.getId());
            return components;
        });
        return Stream.concat(implementedServiceTriggerComponents, customUriTriggerComponents).reduce(this::mergeComponents).orElse(new Components());
    }

    private String addSuffixToRef(String ref, String suffix) {
        return ref.startsWith("#/components/schemas/") ? ref + "-" + suffix : ref;
    }

    private String updateSchemasRefAndAddSuffixToRef(String ref, String suffix) {
        return this.addSuffixToRef(ref.replace("#/definitions/", "#/components/schemas/"), suffix);
    }

    private Components buildComponentsFromValidationSchema(String validationSchemaText) {
        ApiSpecificationFormat format = this.guessFormat(validationSchemaText);
        ObjectMapper mapper = this.getSpecificationMapper(format);
        try {
            JsonNode schemaNode = mapper.readTree(validationSchemaText);
            JsonNode definitionsNode = schemaNode.get("definitions");
            if (Objects.isNull(definitionsNode)) {
                return new Components();
            }
            HashMap<String, Schema> schemas = new HashMap<String, Schema>();
            Iterator fieldIterator = definitionsNode.fields();
            while (fieldIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)fieldIterator.next();
                Schema schema = (Schema)mapper.treeToValue((TreeNode)entry.getValue(), Schema.class);
                schemas.put((String)entry.getKey(), schema);
            }
            return new Components().schemas(schemas);
        }
        catch (JsonProcessingException exception) {
            throw new ApiSpecificationExportException("Failed to parse validation schema", (Exception)((Object)exception));
        }
    }

    private OpenAPI getSpecification(String specificationId) {
        String specificationText = this.systemModelService.getMainSystemModelSource(specificationId);
        ApiSpecificationFormat format = this.guessFormat(specificationText);
        ObjectMapper mapper = this.getSpecificationMapper(format);
        try {
            return (OpenAPI)mapper.readValue(specificationText, OpenAPI.class);
        }
        catch (JsonProcessingException exception) {
            throw new ApiSpecificationExportException("Failed to parse specification", (Exception)((Object)exception));
        }
    }

    private Components mergeComponents(Components c0, Components c1) {
        if (Objects.isNull(c0)) {
            return c1;
        }
        if (Objects.isNull(c1)) {
            return c0;
        }
        return new Components().schemas(this.mergeMaps(c0.getSchemas(), c1.getSchemas())).responses(this.mergeMaps(c0.getResponses(), c1.getResponses())).parameters(this.mergeMaps(c0.getParameters(), c1.getParameters())).examples(this.mergeMaps(c0.getExamples(), c1.getExamples())).requestBodies(this.mergeMaps(c0.getRequestBodies(), c1.getRequestBodies())).headers(this.mergeMaps(c0.getHeaders(), c1.getHeaders())).securitySchemes(this.mergeMaps(c0.getSecuritySchemes(), c1.getSecuritySchemes())).links(this.mergeMaps(c0.getLinks(), c1.getLinks())).callbacks(this.mergeMaps(c0.getCallbacks(), c1.getCallbacks())).extensions(this.mergeMaps(c0.getExtensions(), c1.getExtensions()));
    }

    private <T> Map<String, T> mergeMaps(Map<String, T> m0, Map<String, T> m1) {
        return Stream.of(m0, m1).filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private PathItem.HttpMethod toOpenApiHttpMethod(HttpMethod method) {
        return PathItem.HttpMethod.valueOf((String)method.name());
    }

    private Operation buildOperation(ChainElement element, ElementRoute route, HttpMethod method) {
        return TriggerUtils.isImplementedServiceTrigger((ChainElement)element) ? this.buildOperationForImplementedServiceTrigger(element) : this.buildOperationForCustomUriTrigger(element, route, method);
    }

    private Operation buildOperationForImplementedServiceTrigger(ChainElement element) {
        String modelId = TriggerUtils.getImplementedServiceTriggerSpecificationId((ChainElement)element);
        String operationId = TriggerUtils.getImplementedServiceTriggerOperationId((ChainElement)element);
        String operationSpecificationText = this.findOperation(operationId).getSpecification().toString();
        ApiSpecificationFormat format = this.guessFormat(operationSpecificationText);
        ObjectMapper mapper = this.getSpecificationMapper(format);
        try {
            Operation operation = (Operation)mapper.readValue(operationSpecificationText, Operation.class);
            this.updateOperationId(operation, element);
            this.updateReferencesForOperation(operation, ref -> this.addSuffixToRef((String)ref, modelId));
            return operation;
        }
        catch (JsonProcessingException exception) {
            throw new ApiSpecificationExportException("Failed to parse operation specification", (Exception)((Object)exception));
        }
    }

    private void updateOperationId(Operation operation, ChainElement element) {
        operation.setOperationId(operation.getOperationId() + "-" + element.getId());
    }

    private void updateReferencesForComponents(Components components, Function<String, String> refModifier) {
        if (Objects.isNull(components)) {
            return;
        }
        this.updateReferencesForSchemas(components.getSchemas(), refModifier);
        this.updateReferencesForApiResponses(components.getResponses(), refModifier);
        Map parameters = components.getParameters();
        if (Objects.nonNull(parameters)) {
            this.updateReferencesForParameters(parameters.values(), refModifier);
        }
        this.updateReferencesForExamples(components.getExamples(), refModifier);
        this.updateReferencesForRequestBodies(components.getRequestBodies(), refModifier);
        this.updateReferencesForHeaders(components.getHeaders(), refModifier);
        this.updateReferencesForSecuritySchemes(components.getSecuritySchemes(), refModifier);
        this.updateReferencesForLinks(components.getLinks(), refModifier);
        this.updateReferencesForCallbacks(components.getCallbacks(), refModifier);
    }

    private void updateIdentifiersForComponents(Components components, String modelId) {
        if (Objects.isNull(components)) {
            return;
        }
        this.updateComponentMapKeys(components.getSchemas(), modelId);
        this.updateComponentMapKeys(components.getResponses(), modelId);
        this.updateComponentMapKeys(components.getParameters(), modelId);
        this.updateComponentMapKeys(components.getExamples(), modelId);
        this.updateComponentMapKeys(components.getRequestBodies(), modelId);
        this.updateComponentMapKeys(components.getHeaders(), modelId);
        this.updateComponentMapKeys(components.getSecuritySchemes(), modelId);
        this.updateComponentMapKeys(components.getLinks(), modelId);
        this.updateComponentMapKeys(components.getCallbacks(), modelId);
    }

    private <T> void updateComponentMapKeys(Map<String, T> componentMap, String modelId) {
        if (Objects.nonNull(componentMap)) {
            Map<String, Object> m = componentMap.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey() + "-" + modelId, Map.Entry::getValue));
            componentMap.clear();
            componentMap.putAll(m);
        }
    }

    private void updateReferencesForSchemas(Map<String, Schema> schemas, Function<String, String> refModifier) {
        if (Objects.nonNull(schemas)) {
            schemas.values().forEach(schema -> this.updateReferencesForSchema((Schema)schema, refModifier));
        }
    }

    private void updateReferencesForExamples(Map<String, Example> examples, Function<String, String> refModifier) {
        if (Objects.nonNull(examples)) {
            examples.values().stream().filter(Objects::nonNull).forEach(example -> {
                if (Objects.nonNull(example.get$ref())) {
                    example.set$ref((String)refModifier.apply(example.get$ref()));
                }
            });
        }
    }

    private void updateReferencesForRequestBodies(Map<String, RequestBody> requestBodies, Function<String, String> refModifier) {
        if (Objects.nonNull(requestBodies)) {
            requestBodies.values().forEach(requestBody -> this.updateReferencesForRequestBody((RequestBody)requestBody, refModifier));
        }
    }

    private void updateReferencesForSecuritySchemes(Map<String, SecurityScheme> securitySchemes, Function<String, String> refModifier) {
        if (Objects.nonNull(securitySchemes)) {
            securitySchemes.values().stream().filter(Objects::nonNull).forEach(securityScheme -> {
                if (Objects.nonNull(securityScheme.get$ref())) {
                    securityScheme.set$ref((String)refModifier.apply(securityScheme.get$ref()));
                }
            });
        }
    }

    private void updateReferencesForOperation(Operation operation, Function<String, String> refModifier) {
        if (Objects.isNull(operation)) {
            return;
        }
        this.updateReferencesForParameters(operation.getParameters(), refModifier);
        this.updateReferencesForRequestBody(operation.getRequestBody(), refModifier);
        this.updateReferencesForApiResponses((Map<String, ApiResponse>)operation.getResponses(), refModifier);
        this.updateReferencesForCallbacks(operation.getCallbacks(), refModifier);
    }

    private void updateReferencesForCallbacks(Map<String, Callback> callbacks, Function<String, String> refModifier) {
        if (Objects.nonNull(callbacks)) {
            callbacks.values().stream().filter(Objects::nonNull).forEach(callback -> {
                if (Objects.nonNull(callback.get$ref())) {
                    callback.set$ref((String)refModifier.apply(callback.get$ref()));
                }
                callback.values().stream().filter(Objects::nonNull).forEach(pathItem -> {
                    if (Objects.nonNull(pathItem.get$ref())) {
                        pathItem.set$ref((String)refModifier.apply(pathItem.get$ref()));
                    }
                    this.updateReferencesForOperation(pathItem.getDelete(), refModifier);
                    this.updateReferencesForOperation(pathItem.getGet(), refModifier);
                    this.updateReferencesForOperation(pathItem.getOptions(), refModifier);
                    this.updateReferencesForOperation(pathItem.getPatch(), refModifier);
                    this.updateReferencesForOperation(pathItem.getHead(), refModifier);
                    this.updateReferencesForOperation(pathItem.getPatch(), refModifier);
                    this.updateReferencesForOperation(pathItem.getPost(), refModifier);
                    this.updateReferencesForOperation(pathItem.getTrace(), refModifier);
                    this.updateReferencesForParameters(pathItem.getParameters(), refModifier);
                });
            });
        }
    }

    private void updateReferencesForRequestBody(RequestBody requestBody, Function<String, String> refModifier) {
        if (Objects.nonNull(requestBody)) {
            if (Objects.nonNull(requestBody.get$ref())) {
                requestBody.set$ref(refModifier.apply(requestBody.get$ref()));
            }
            this.updateReferencesForContent(requestBody.getContent(), refModifier);
        }
    }

    private void updateReferencesForApiResponses(Map<String, ApiResponse> responses, Function<String, String> refModifier) {
        if (Objects.nonNull(responses)) {
            responses.values().stream().filter(Objects::nonNull).forEach(response -> {
                if (Objects.nonNull(response.get$ref())) {
                    response.set$ref((String)refModifier.apply(response.get$ref()));
                }
                this.updateReferencesForContent(response.getContent(), refModifier);
                this.updateReferencesForHeaders(response.getHeaders(), refModifier);
                this.updateReferencesForLinks(response.getLinks(), refModifier);
            });
        }
    }

    private void updateReferencesForLinks(Map<String, Link> links, Function<String, String> refModifier) {
        if (Objects.nonNull(links)) {
            links.values().stream().filter(Objects::nonNull).forEach(link -> {
                if (Objects.nonNull(link.get$ref())) {
                    link.set$ref((String)refModifier.apply(link.get$ref()));
                }
                if (Objects.nonNull(link.getOperationRef())) {
                    // empty if block
                }
                if (Objects.nonNull(link.getOperationId())) {
                    // empty if block
                }
                this.updateReferencesForHeaders(link.getHeaders(), refModifier);
            });
        }
    }

    private void updateReferencesForContent(Content content, Function<String, String> refModifier) {
        if (Objects.nonNull(content)) {
            content.values().stream().filter(Objects::nonNull).forEach(mediaType -> {
                Map encoding = mediaType.getEncoding();
                if (Objects.nonNull(encoding)) {
                    encoding.values().stream().filter(Objects::nonNull).forEach(e -> this.updateReferencesForHeaders(e.getHeaders(), refModifier));
                }
                this.updateReferencesForSchema(mediaType.getSchema(), refModifier);
            });
        }
    }

    private void updateReferencesForSchema(Schema schema, Function<String, String> refModifier) {
        if (Objects.nonNull(schema)) {
            if (Objects.nonNull(schema.get$ref())) {
                schema.set$ref(refModifier.apply(schema.get$ref()));
            }
            this.updateReferencesForSchemas(schema.getProperties(), refModifier);
            if (schema instanceof ArraySchema) {
                this.updateReferencesForSchema(((ArraySchema)schema).getItems(), refModifier);
            }
            if (schema instanceof ComposedSchema) {
                ComposedSchema composedSchema = (ComposedSchema)schema;
                Stream.of(composedSchema.getAllOf(), composedSchema.getOneOf(), composedSchema.getAnyOf()).filter(Objects::nonNull).flatMap(Collection::stream).forEach(s -> this.updateReferencesForSchema((Schema)s, refModifier));
            }
        }
    }

    private void updateReferencesForParameters(Collection<Parameter> parameters, Function<String, String> refModifier) {
        if (Objects.nonNull(parameters)) {
            parameters.forEach(parameter -> {
                if (Objects.nonNull(parameter.get$ref())) {
                    parameter.set$ref((String)refModifier.apply(parameter.get$ref()));
                }
            });
        }
    }

    private void updateReferencesForHeaders(Map<String, Header> headers, Function<String, String> refModifier) {
        if (Objects.nonNull(headers)) {
            headers.values().stream().filter(Objects::nonNull).forEach(header -> {
                if (Objects.nonNull(header.get$ref())) {
                    header.set$ref((String)refModifier.apply(header.get$ref()));
                }
            });
        }
    }

    private ApiSpecificationFormat guessFormat(String text) {
        return text.trim().startsWith("{") ? ApiSpecificationFormat.JSON : ApiSpecificationFormat.YAML;
    }

    private Operation buildOperationForCustomUriTrigger(ChainElement element, ElementRoute route, HttpMethod method) {
        return new Operation().operationId(this.buildOperationId(element, route, method)).summary(this.buildOperationSummary(element)).description(element.getDescription()).parameters(this.buildCustomUriTriggerParameters(route.getPath())).requestBody(this.buildRequestBodyForCustomUriTrigger(element)).responses(this.buildCustomUriTriggerResponses());
    }

    private String buildOperationSummary(ChainElement element) {
        return this.getElementChain(element).getName() + " - " + element.getName();
    }

    private String buildOperationId(ChainElement element, ElementRoute route, HttpMethod method) {
        return method.name().toLowerCase() + "-" + StringUtils.strip((String)route.getPath().replaceAll("[^\\w\\d]+", "-").toLowerCase(), (String)"-") + "-" + element.getId();
    }

    private ApiResponses buildCustomUriTriggerResponses() {
        return new ApiResponses().addApiResponse("200", new ApiResponse().description("Operation success"))._default(new ApiResponse().description("Unexpected error"));
    }

    private List<Parameter> buildCustomUriTriggerParameters(String path) {
        Pattern pattern = Pattern.compile("\\{([^}]+)}");
        Matcher matcher = pattern.matcher(path);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        while (matcher.find()) {
            Parameter parameter = new Parameter().name(matcher.group(1)).in("path").required(Boolean.valueOf(true)).schema(new Schema().type("string"));
            parameters.add(parameter);
        }
        return parameters;
    }

    private RequestBody buildRequestBodyForCustomUriTrigger(ChainElement element) {
        String validationSchemaText = TriggerUtils.getHttpTriggerValidationSchema((ChainElement)element);
        if (StringUtils.isBlank((CharSequence)validationSchemaText)) {
            return null;
        }
        Content content = this.buildContentFromValidationSchema(validationSchemaText);
        this.updateReferencesForContent(content, ref -> this.updateSchemasRefAndAddSuffixToRef((String)ref, element.getId()));
        return Objects.isNull(content) ? null : new RequestBody().content(content);
    }

    private Content buildContentFromValidationSchema(String validationSchemaText) {
        ApiSpecificationFormat format = this.guessFormat(validationSchemaText);
        ObjectMapper mapper = this.getSpecificationMapper(format);
        try {
            JsonNode schemaNode = mapper.readTree(validationSchemaText);
            Schema schema = (Schema)mapper.treeToValue((TreeNode)schemaNode, Schema.class);
            return new Content().addMediaType("application/json", new MediaType().schema(schema));
        }
        catch (JsonProcessingException exception) {
            throw new ApiSpecificationExportException("Failed to parse validation schema", (Exception)((Object)exception));
        }
    }

    private org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation findOperation(String operationId) {
        return (org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation)this.operationRepository.findById((Object)operationId).orElseThrow(() -> new EntityNotFoundException(OPERATION_WITH_ID_NOT_FOUND_MESSAGE + operationId));
    }

    private static class SpecificationBuildParameters {
        Collection<ChainElement> elements;
        boolean externalRoutes;

        SpecificationBuildParameters(Collection<ChainElement> elements, boolean externalRoutes) {
            this.elements = elements;
            this.externalRoutes = externalRoutes;
        }

        public static SpecificationBuildParametersBuilder builder() {
            return new SpecificationBuildParametersBuilder();
        }

        public Collection<ChainElement> getElements() {
            return this.elements;
        }

        public boolean isExternalRoutes() {
            return this.externalRoutes;
        }

        public void setElements(Collection<ChainElement> elements) {
            this.elements = elements;
        }

        public void setExternalRoutes(boolean externalRoutes) {
            this.externalRoutes = externalRoutes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecificationBuildParameters)) {
                return false;
            }
            SpecificationBuildParameters other = (SpecificationBuildParameters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isExternalRoutes() != other.isExternalRoutes()) {
                return false;
            }
            Collection<ChainElement> this$elements = this.getElements();
            Collection<ChainElement> other$elements = other.getElements();
            return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpecificationBuildParameters;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExternalRoutes() ? 79 : 97);
            Collection<ChainElement> $elements = this.getElements();
            result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
            return result;
        }

        public String toString() {
            return "ApiSpecificationExportService.SpecificationBuildParameters(elements=" + String.valueOf(this.getElements()) + ", externalRoutes=" + this.isExternalRoutes() + ")";
        }

        public static class SpecificationBuildParametersBuilder {
            private Collection<ChainElement> elements;
            private boolean externalRoutes;

            SpecificationBuildParametersBuilder() {
            }

            public SpecificationBuildParametersBuilder elements(Collection<ChainElement> elements) {
                this.elements = elements;
                return this;
            }

            public SpecificationBuildParametersBuilder externalRoutes(boolean externalRoutes) {
                this.externalRoutes = externalRoutes;
                return this;
            }

            public SpecificationBuildParameters build() {
                return new SpecificationBuildParameters(this.elements, this.externalRoutes);
            }

            public String toString() {
                return "ApiSpecificationExportService.SpecificationBuildParameters.SpecificationBuildParametersBuilder(elements=" + String.valueOf(this.elements) + ", externalRoutes=" + this.externalRoutes + ")";
            }
        }
    }
}

