/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport;

import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.ImportSession;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.repository.ImportSessionRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImportSessionService {
    private static final Logger log = LoggerFactory.getLogger(ImportSessionService.class);
    public static final short COMMON_VARIABLES_IMPORT_PERCENTAGE_THRESHOLD = 10;
    public static final short SERVICE_IMPORT_PERCENTAGE_THRESHOLD = 30;
    public static final short CHAIN_IMPORT_PERCENTAGE_THRESHOLD = 60;
    public static final short SNAPSHOT_BUILD_PERCENTAGE_THRESHOLD = 80;
    private final Integer importSessionLifetimeMinutes;
    private final ImportSessionRepository importSessionRepository;

    @Autowired
    public ImportSessionService(@Value(value="${qip.import.session-lifetime-minutes:300}") Integer importSessionLifetimeMinutes, ImportSessionRepository importSessionRepository) {
        this.importSessionLifetimeMinutes = importSessionLifetimeMinutes;
        this.importSessionRepository = importSessionRepository;
    }

    @Nullable
    public ImportSession getImportSession(String importId) {
        return this.importSessionRepository.findById(importId).orElse(null);
    }

    public void saveImportSession(ImportSession importSession) {
        this.importSessionRepository.save(importSession);
    }

    @Transactional
    public void deleteObsoleteImportSessionStatuses() {
        this.importSessionRepository.deleteSessionsOlderThan(this.importSessionLifetimeMinutes);
    }

    public void setImportProgressPercentage(String importId, int percentage) {
        if (importId == null) {
            return;
        }
        ImportSession importSession = this.getImportSession(importId);
        if (importSession == null) {
            importSession = new ImportSession();
            importSession.setId(importId);
        }
        importSession.setCompletion(percentage);
        this.saveImportSession(importSession);
    }

    public void calculateImportStatus(String importId, int total, int counter, int fromPercentage, int toPercentage) {
        if (importId == null) {
            return;
        }
        int percentage = total == 0 ? toPercentage : (int)((double)fromPercentage + (double)(toPercentage - fromPercentage) * ((double)counter / (double)total));
        this.setImportProgressPercentage(importId, percentage);
    }
}

