/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport;

import io.micrometer.core.instrument.util.StringUtils;
import jakarta.persistence.EntityNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationSource;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.service.SpecificationGroupService;
import org.qubership.integration.platform.runtime.catalog.service.SystemModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;

@Service
public class SpecificationExportService {
    private static final Logger log = LoggerFactory.getLogger(SpecificationExportService.class);
    private final SystemModelService systemModelService;
    private final SpecificationGroupService specificationGroupService;
    private final ActionsLogService actionLogger;

    @Autowired
    SpecificationExportService(SystemModelService systemModelService, SpecificationGroupService specificationGroupService, ActionsLogService actionLogger) {
        this.systemModelService = systemModelService;
        this.specificationGroupService = specificationGroupService;
        this.actionLogger = actionLogger;
    }

    public Pair<byte[], String> exportSpecifications(List<String> specificationIds, String specificationGroupId) {
        Pair pair;
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            String filename;
            block18: {
                SystemModel singleSystemModel = null;
                if (specificationIds != null && specificationIds.size() == 1) {
                    singleSystemModel = this.systemModelService.getSystemModelOrElseNull(specificationIds.get(0));
                }
                if (singleSystemModel != null && singleSystemModel.getSpecificationSources().size() == 1) {
                    SpecificationSource specificationSource = (SpecificationSource)singleSystemModel.getSpecificationSources().get(0);
                    this.writeFile(fos, specificationSource.getSource());
                    filename = ExportImportUtils.getSpecificationFileName((SpecificationSource)specificationSource);
                    this.logSpecificationExport(singleSystemModel);
                } else {
                    try (ZipOutputStream zipOut = new ZipOutputStream(fos);){
                        if (StringUtils.isNotBlank((String)specificationGroupId)) {
                            SpecificationGroup specificationGroup = this.specificationGroupService.getById(specificationGroupId);
                            for (SystemModel systemModel : specificationGroup.getSystemModels()) {
                                if (specificationIds != null && !specificationIds.contains(systemModel.getId())) continue;
                                if (systemModel.getSpecificationSources().isEmpty()) {
                                    throw new EntityNotFoundException("Can't find specification source for version " + systemModel.getVersion());
                                }
                                ExportImportUtils.writeZip((ZipOutputStream)zipOut, (SystemModel)systemModel);
                                this.logSpecificationExport(systemModel);
                            }
                            filename = ExportImportUtils.generateArchiveExportName();
                            break block18;
                        }
                        throw new EntityNotFoundException("Can't find specification source");
                    }
                }
            }
            pair = Pair.of((Object)fos.toByteArray(), (Object)filename);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unknown exception during file creation: " + e.getMessage());
            }
        }
        fos.close();
        return pair;
    }

    private void writeFile(ByteArrayOutputStream fos, String source) {
        if (source == null) {
            throw new EntityNotFoundException("Can't find specification source");
        }
        byte[] sourceBytes = source.getBytes();
        fos.write(sourceBytes, 0, sourceBytes.length);
    }

    public void logSpecificationExport(SystemModel specification) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.SPECIFICATION).entityId(specification.getId()).entityName(specification.getName()).parentType(EntityType.SPECIFICATION_GROUP).parentId(specification.getSpecificationGroup().getId()).parentName(specification.getSpecificationGroup().getName()).operation(LogOperation.EXPORT).build());
    }
}

