/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.ChainLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.MaskedField;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ChainRepository;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.DeploymentExternalEntity;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportEntityStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitRequestAction;
import org.qubership.integration.platform.runtime.catalog.service.FolderService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.entity.ChainDeserializationResult;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.entity.ElementDeserializationResult;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.entity.FolderSerializeEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Deprecated(since="2023.4")
public class ChainDeserializer
extends StdDeserializer<ChainDeserializationResult> {
    private static final Logger log = LoggerFactory.getLogger(ChainDeserializer.class);
    private final ObjectMapper objectMapper;
    private final ChainRepository chainRepository;
    private final FolderService folderService;

    @Autowired
    public ChainDeserializer(@Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, ChainRepository chainRepository, @Lazy FolderService folderService) {
        super((Class)null);
        this.objectMapper = objectMapper;
        this.chainRepository = chainRepository;
        this.folderService = folderService;
    }

    public ChainDeserializationResult deserialize(JsonParser parser, DeserializationContext context) {
        ChainDeserializationResult result = new ChainDeserializationResult();
        try {
            Chain resultChain;
            YAMLMapper mapper = (YAMLMapper)parser.getCodec();
            JsonNode node = (JsonNode)mapper.readTree(parser);
            JsonNode idNode = node.get("id");
            JsonNode nameNode = node.get("name");
            JsonNode descriptionNode = node.get("description");
            JsonNode labelsNode = node.get("labels");
            JsonNode maskedFieldsNode = node.get("maskedFields");
            JsonNode elementsNode = node.get("elements");
            JsonNode dependenciesNode = node.get("dependencies");
            JsonNode folderNode = node.get("folder");
            JsonNode deploymentsNode = node.get("deployments");
            JsonNode modifiedWhenNode = node.get("modifiedWhen");
            JsonNode deployActionNode = node.get("deployAction");
            JsonNode businessDescription = node.get("businessDescription");
            JsonNode assumption = node.get("assumptions");
            JsonNode outOfScope = node.get("outOfScope");
            Optional chainOptional = this.chainRepository.findById((Object)idNode.asText());
            if (chainOptional.isPresent()) {
                resultChain = (Chain)chainOptional.get();
                resultChain.setModifiedWhen(new Timestamp(System.currentTimeMillis()));
                result.setStatus(ImportEntityStatus.UPDATED);
            } else {
                resultChain = ((Chain.ChainBuilder)((Chain.ChainBuilder)((Chain.ChainBuilder)Chain.builder().id(idNode.asText())).createdWhen(new Timestamp(System.currentTimeMillis()))).modifiedWhen(new Timestamp(modifiedWhenNode == null ? System.currentTimeMillis() : modifiedWhenNode.asLong()))).build();
                result.setStatus(ImportEntityStatus.CREATED);
            }
            resultChain.setName(nameNode != null ? nameNode.asText() : null);
            resultChain.setDescription(descriptionNode != null ? descriptionNode.asText() : null);
            resultChain.setBusinessDescription(businessDescription != null ? businessDescription.asText() : null);
            resultChain.setAssumptions(assumption != null ? assumption.asText() : null);
            resultChain.setOutOfScope(outOfScope != null ? outOfScope.asText() : null);
            result.setDefaultSwimlaneId(node.at(ExportImportUtils.toJsonPointer((String[])new String[]{"default-swimlane-id"})).asText(null));
            result.setReuseSwimlaneId(node.at(ExportImportUtils.toJsonPointer((String[])new String[]{"reuse-swimlane-id"})).asText(null));
            this.restoreFolders(folderNode, resultChain);
            this.restoreLabels(labelsNode, resultChain);
            this.restoreMaskedFields(maskedFieldsNode, resultChain);
            this.restoreElements(elementsNode, result, resultChain, mapper);
            this.restoreDependencies(dependenciesNode, resultChain);
            result.setChain(resultChain);
            result.setDeployAction(deployActionNode != null ? ChainCommitRequestAction.valueOf(deployActionNode.asText()) : null);
            this.restoreDeployments(deploymentsNode, result);
        }
        catch (Exception e) {
            log.error("Exception while chain deserialization: ", (Throwable)e);
            result.setStatus(ImportEntityStatus.ERROR);
            result.setErrorMessage("Exception while chain deserialization: " + e.getMessage());
        }
        return result;
    }

    private void restoreDeployments(JsonNode deploymentsNode, ChainDeserializationResult deserializationResult) throws JsonProcessingException {
        if (deploymentsNode == null) {
            return;
        }
        DeploymentExternalEntity[] deploymentsSerialized = (DeploymentExternalEntity[])this.objectMapper.treeToValue((TreeNode)deploymentsNode, DeploymentExternalEntity[].class);
        if (deploymentsSerialized != null) {
            deserializationResult.setDeployments(Arrays.asList(deploymentsSerialized));
        }
    }

    private void restoreFolders(JsonNode foldersNode, Chain chain) throws JsonProcessingException {
        if (foldersNode != null) {
            FolderSerializeEntity folderSerializeEntity = (FolderSerializeEntity)this.objectMapper.treeToValue((TreeNode)foldersNode, FolderSerializeEntity.class);
            Folder folder = this.restoreSubFolders(folderSerializeEntity, null);
            while (folderSerializeEntity.getSubfolder() != null) {
                folderSerializeEntity = folderSerializeEntity.getSubfolder();
                folder = this.restoreSubFolders(folderSerializeEntity, folder);
            }
            chain.setParentFolder(folder);
        }
    }

    private Folder restoreSubFolders(FolderSerializeEntity folderSerializeEntity, Folder parentFolder) {
        Folder folder = this.folderService.findFirstByName(folderSerializeEntity.getName(), parentFolder);
        if (folder == null) {
            folder = ((Folder.FolderBuilder)((Folder.FolderBuilder)((Folder.FolderBuilder)Folder.builder().name(folderSerializeEntity.getName())).description(folderSerializeEntity.getDescription())).parentFolder(folder)).build();
        }
        return folder;
    }

    private void restoreMaskedFields(JsonNode maskedFieldsNode, Chain chain) {
        this.deleteMaskedFields(chain);
        if (maskedFieldsNode != null) {
            HashSet<String> fieldNames = new HashSet<String>();
            for (JsonNode maskedFieldNode : maskedFieldsNode) {
                fieldNames.add(maskedFieldNode.get("name").asText());
            }
            for (String fieldName : fieldNames) {
                chain.getMaskedFields().add(((MaskedField.MaskedFieldBuilder)MaskedField.builder().name(fieldName)).chain(chain).build());
            }
        }
    }

    private void deleteMaskedFields(Chain chain) {
        Set maskedFields = chain.getMaskedFields();
        maskedFields.clear();
    }

    private void restoreElements(JsonNode elementsNode, ChainDeserializationResult chainDeserializationResult, Chain resultChain, YAMLMapper mapper) throws JsonProcessingException {
        HashMap swimlanes = new HashMap();
        HashMap<String, Object> newElementsMap = new HashMap<String, Object>();
        HashMap<String, String> propertyFilenames = new HashMap<String, String>();
        if (elementsNode != null) {
            JsonPointer elementTypePointer = ExportImportUtils.toJsonPointer((String[])new String[]{"element-type"});
            List<JsonNode> elementNodeList = StreamSupport.stream(elementsNode.spliterator(), false).peek(elementNode -> {
                if ("swimlane".equals(elementNode.at(elementTypePointer).asText())) {
                    ElementDeserializationResult swimlaneDeserializationResult;
                    try {
                        swimlaneDeserializationResult = (ElementDeserializationResult)mapper.readValue(elementNode.toString(), ElementDeserializationResult.class);
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException("Exception while swimlane deserialization", e);
                    }
                    ChainElement patt0$temp = swimlaneDeserializationResult.getElement();
                    if (!(patt0$temp instanceof SwimlaneChainElement)) {
                        throw new RuntimeException("Swimlane converted to invalid type");
                    }
                    SwimlaneChainElement swimlane = (SwimlaneChainElement)patt0$temp;
                    swimlanes.put(swimlane.getId(), swimlane);
                }
            }).filter(elementNode -> !"swimlane".equals(elementNode.at(elementTypePointer).asText())).toList();
            resultChain.setDefaultSwimlane((SwimlaneChainElement)swimlanes.get(chainDeserializationResult.getDefaultSwimlaneId()));
            resultChain.setReuseSwimlane((SwimlaneChainElement)swimlanes.get(chainDeserializationResult.getReuseSwimlaneId()));
            for (JsonNode elementNode2 : elementNodeList) {
                ElementDeserializationResult elementDeserializeEntity = (ElementDeserializationResult)mapper.readValue(elementNode2.toString(), ElementDeserializationResult.class);
                ChainElement element2 = elementDeserializeEntity.getElement();
                Optional.ofNullable((SwimlaneChainElement)swimlanes.get(elementDeserializeEntity.getSwimlaneIdByElementId(element2.getId()))).ifPresent(swimlane -> swimlane.addElement(element2));
                newElementsMap.put(element2.getId(), element2);
                if (!CollectionUtils.isEmpty(elementDeserializeEntity.getElementPropertiesFilenames())) {
                    propertyFilenames.putAll(elementDeserializeEntity.getElementPropertiesFilenames());
                }
                if (!(element2 instanceof ContainerChainElement)) continue;
                ContainerChainElement container = (ContainerChainElement)element2;
                Map<String, ChainElement> allChildren = container.extractAllChildElements().entrySet().stream().peek(entry -> Optional.ofNullable((SwimlaneChainElement)swimlanes.get(elementDeserializeEntity.getSwimlaneIdByElementId((String)entry.getKey()))).ifPresent(swimlane -> swimlane.addElement((ChainElement)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                newElementsMap.putAll(allChildren);
            }
            newElementsMap.putAll(swimlanes);
            List elements = resultChain.getElements();
            elements.removeIf(element -> newElementsMap.containsKey(element.getId()));
            this.deleteExcessElements(resultChain, new ArrayList<ChainElement>(elements));
            resultChain.addElements(newElementsMap.values());
        }
        chainDeserializationResult.setPropertiesFileNames(propertyFilenames);
    }

    private void deleteExcessElements(Chain chain, Collection<ChainElement> elementsToDelete) {
        Map elementsToDeleteMap = elementsToDelete.stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity()));
        for (ChainElement element : elementsToDelete) {
            ContainerChainElement parent = element.getParent();
            if (parent == null || elementsToDeleteMap.containsKey(parent.getId())) continue;
            parent.removeChildElement(element);
        }
        chain.removeElements(elementsToDelete);
    }

    private void restoreDependencies(JsonNode dependenciesNode, Chain chain) {
        this.deleteDependencies(chain);
        if (dependenciesNode != null) {
            for (JsonNode depNode : dependenciesNode) {
                JsonNode fromId = depNode.get("from");
                JsonNode toId = depNode.get("to");
                ChainElement from = chain.getElements().stream().filter(el -> el.getId().equals(fromId.asText())).findFirst().orElseThrow();
                ChainElement to = chain.getElements().stream().filter(el -> el.getId().equals(toId.asText())).findFirst().orElseThrow();
                Dependency dep = Dependency.of((ChainElement)from, (ChainElement)to);
                from.addOutputDependency(dep);
                to.addInputDependency(dep);
            }
        }
    }

    private void deleteDependencies(Chain chain) {
        List elements = chain.getElements();
        HashSet dependencies = new HashSet();
        if (elements != null) {
            elements.forEach(el -> {
                dependencies.addAll(el.getInputDependencies());
                dependencies.addAll(el.getOutputDependencies());
                el.getInputDependencies().clear();
                el.getOutputDependencies().clear();
            });
        }
    }

    private void restoreLabels(JsonNode labelsNode, Chain chain) {
        if (labelsNode == null || !labelsNode.isArray()) {
            return;
        }
        StreamSupport.stream(labelsNode.spliterator(), false).map(JsonNode::asText).distinct().forEach(label -> chain.addLabel(((ChainLabel.ChainLabelBuilder)ChainLabel.builder().name(label)).chain(chain).build()));
    }
}

