/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.ImportFileMigration;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.ChainImportFileMigration;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.system.ServiceImportFileMigration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportFileMigrationUtils {
    private static List<Integer> actualChainFileMigrationVersions;
    private static List<Integer> actualServiceFileMigrationVersions;

    @Autowired
    public ImportFileMigrationUtils(List<ChainImportFileMigration> chainImportFileMigrations, List<ServiceImportFileMigration> serviceImportFileMigrations) {
        actualChainFileMigrationVersions = this.calculateActualFileMigrationVersions(chainImportFileMigrations);
        actualServiceFileMigrationVersions = this.calculateActualFileMigrationVersions(serviceImportFileMigrations);
    }

    public static List<Integer> getActualChainFileMigrationVersions() {
        return actualChainFileMigrationVersions;
    }

    public static List<Integer> getActualServiceFileMigrationVersions() {
        return actualServiceFileMigrationVersions;
    }

    public static void renameProperty(ObjectNode properties, String propertyNameFrom, String propertyNameTo) {
        JsonNode property = properties.get(propertyNameFrom);
        if (property != null) {
            properties.set(propertyNameTo, property);
            properties.remove(propertyNameFrom);
        }
    }

    private List<Integer> calculateActualFileMigrationVersions(List<? extends ImportFileMigration> importFileMigrations) {
        return importFileMigrations.stream().map(ImportFileMigration::getVersion).toList();
    }
}

