/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.chain.ChainElementsExternalEntityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.util.CollectionUtils;

@JsonComponent
@Deprecated(since="2023.4")
public class ChainElementSerializer
extends StdSerializer<ChainElement> {
    private static final Logger log = LoggerFactory.getLogger(ChainElementSerializer.class);

    public ChainElementSerializer() {
        this(null);
    }

    public ChainElementSerializer(Class<ChainElement> t) {
        super(t);
    }

    public void serialize(ChainElement element, JsonGenerator generator, SerializerProvider serializer) throws IOException {
        try {
            ContainerChainElement container;
            generator.writeStartObject();
            generator.writeStringField("id", element.getId());
            if (element.getName() != null) {
                generator.writeStringField("name", element.getName());
            }
            if (element.getDescription() != null) {
                generator.writeStringField("description", element.getDescription());
            }
            if (element.getType() != null) {
                generator.writeStringField("element-type", element.getType());
            }
            if (element.getSwimlane() != null) {
                generator.writeStringField("swimlane-id", element.getSwimlane().getId());
            }
            this.writeProperties(element, generator);
            if (element instanceof ContainerChainElement && !CollectionUtils.isEmpty((Collection)(container = (ContainerChainElement)element).getElements())) {
                generator.writeObjectField("children", (Object)container.getElements());
            }
            generator.writeEndObject();
        }
        catch (IOException e) {
            log.warn("Exception while serializing ChainElement {}, exception: ", (Object)element.getId(), (Object)e);
            throw e;
        }
    }

    private void writeProperties(ChainElement element, JsonGenerator generator) throws IOException {
        TreeMap<String, Object> properties = new TreeMap<String, Object>(ChainElementsExternalEntityMapper.preSortProperties(element.getProperties()));
        if (!CollectionUtils.isEmpty(properties)) {
            ArrayList propsToExportSeparately = ExportImportUtils.getPropertiesToExportInSeparateFile((ChainElement)element);
            if (!CollectionUtils.isEmpty((Collection)propsToExportSeparately) && (ExportImportUtils.isPropertiesFileGroove((Map)element.getProperties()) || ExportImportUtils.isPropertiesFileSql((Map)element.getProperties()) || propsToExportSeparately.stream().anyMatch(p -> properties.get(p) != null))) {
                generator.writeObjectField("properties-filename", (Object)ExportImportUtils.generatePropertiesFileName((ChainElement)element));
            }
            properties.keySet().removeAll(propsToExportSeparately);
            if ("service-call".equals(element.getType())) {
                this.writeFileNameInProperty(element, properties, generator);
            } else {
                generator.writeObjectField("properties", properties);
            }
        }
    }

    private void writeFileNameInProperty(ChainElement element, Map<String, Object> properties, JsonGenerator generator) throws IOException {
        List afterPropertyList = (List)properties.get("after");
        Map beforePropMap = (Map)properties.get("before");
        HashMap<String, Object> scriptContent = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty((Collection)afterPropertyList)) {
            for (Map afterProp : afterPropertyList) {
                if ("script".equals(afterProp.get("type"))) {
                    this.setScriptFileNameInProperty((String)ExportImportUtils.getIdOrCode((Map)afterProp), afterProp, ExportImportUtils.generateAfterScriptFileName((String)element.getId(), (Map)afterProp), scriptContent);
                    continue;
                }
                if (null != afterProp.get("type") && StringUtils.contains((CharSequence)((String)afterProp.get("type")), (CharSequence)"mapper")) {
                    this.setMapperFileNameInProperty((String)ExportImportUtils.getIdOrCode((Map)afterProp), afterProp, ExportImportUtils.generateAfterMapperFileName((String)element.getId(), (Map)afterProp), scriptContent);
                    continue;
                }
                if (null != afterProp.get("type")) continue;
                afterProp.remove("properties-filename");
            }
        }
        if (!CollectionUtils.isEmpty((Map)beforePropMap)) {
            if ("script".equals(beforePropMap.get("type"))) {
                this.setScriptFileNameInProperty("before", beforePropMap, ExportImportUtils.generateBeforeScriptFileName((String)element.getId()), scriptContent);
            } else if (null != beforePropMap.get("type")) {
                if ("mapper".equals(beforePropMap.get("type"))) {
                    this.setMapperFileNameInProperty("mapping", beforePropMap, ExportImportUtils.generateBeforeMapperFileName((String)element.getId(), (Map)beforePropMap), scriptContent);
                } else {
                    this.setMapperFileNameInProperty("mappingDescription", beforePropMap, ExportImportUtils.generateBeforeMapperFileName((String)element.getId(), (Map)beforePropMap), scriptContent);
                }
            }
        }
        generator.writeObjectField("properties", properties);
        if (scriptContent.get("before") != null) {
            beforePropMap.put("script", scriptContent.get("before"));
        } else if (scriptContent.get("mappingDescription") != null) {
            beforePropMap.put("mappingDescription", scriptContent.get("mappingDescription"));
        } else if (scriptContent.get("mapping") != null) {
            beforePropMap.put("mapping", scriptContent.get("mapping"));
            this.setSourceAndTargetValue(beforePropMap, scriptContent);
        }
        if (!CollectionUtils.isEmpty((Collection)afterPropertyList)) {
            for (Map afterProp : afterPropertyList) {
                if (scriptContent.get(ExportImportUtils.getIdOrCode((Map)afterProp)) != null && "script".equals(afterProp.get("type"))) {
                    afterProp.put("script", scriptContent.get(ExportImportUtils.getIdOrCode((Map)afterProp)));
                    continue;
                }
                if (scriptContent.get(ExportImportUtils.getIdOrCode((Map)afterProp)) == null || null == afterProp.get("type")) continue;
                if ("mapper".equals(afterProp.get("type"))) {
                    afterProp.put("mapping", scriptContent.get(ExportImportUtils.getIdOrCode((Map)afterProp)));
                    this.setSourceAndTargetValue(afterProp, scriptContent);
                    continue;
                }
                afterProp.put("mappingDescription", scriptContent.get(ExportImportUtils.getIdOrCode((Map)afterProp)));
            }
        }
    }

    private void setSourceAndTargetValue(Map<String, Object> mapperProp, Map<String, Object> scriptContent) {
        mapperProp.put("source", scriptContent.get("source"));
        mapperProp.put("target", scriptContent.get("target"));
    }

    private void setScriptFileNameInProperty(String key, Map<String, Object> properties, String fileName, Map<String, Object> scriptContent) {
        scriptContent.put(key, properties.get("script"));
        properties.keySet().removeAll(Arrays.asList("script"));
        properties.put("properties-filename", fileName);
    }

    private void setMapperFileNameInProperty(String key, Map<String, Object> properties, String fileName, Map<String, Object> scriptContent) {
        if ("mapper".equals(properties.get("type"))) {
            scriptContent.put(key, properties.get("mapping"));
            this.setSourceAndTargetValue(scriptContent, properties);
            properties.keySet().removeAll(Arrays.asList("mapping", "source", "target"));
        } else {
            scriptContent.put(key, properties.get("mappingDescription"));
            properties.keySet().removeAll(Arrays.asList("mappingDescription"));
        }
        properties.put("properties-filename", fileName);
    }
}

