/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.ChainLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.FoldableEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.DeploymentExternalEntity;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitRequestAction;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.entity.FolderSerializeEntity;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.ImportFileMigrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Deprecated(since="2023.4")
public class ChainSerializer
extends StdSerializer<Chain> {
    private static final Logger log = LoggerFactory.getLogger(ChainSerializer.class);

    public ChainSerializer() {
        this(null);
    }

    public ChainSerializer(Class<Chain> t) {
        super(t);
    }

    public void serialize(Chain chain, JsonGenerator generator, SerializerProvider serializer) throws IOException {
        try {
            List<DeploymentExternalEntity> chainDeployments;
            Set<Dependency> chainDependencies;
            Set maskedFields;
            generator.writeStartObject();
            generator.writeStringField("id", chain.getId());
            if (chain.getName() != null) {
                generator.writeStringField("name", chain.getName());
            }
            if (chain.getDescription() != null) {
                generator.writeStringField("description", chain.getDescription());
            }
            if (chain.getModifiedWhen() != null) {
                generator.writeNumberField("modifiedWhen", chain.getModifiedWhen().getTime());
            }
            if (chain.getDefaultSwimlane() != null) {
                generator.writeStringField("default-swimlane-id", chain.getDefaultSwimlane().getId());
            }
            if (chain.getReuseSwimlane() != null) {
                generator.writeStringField("reuse-swimlane-id", chain.getReuseSwimlane().getId());
            }
            if (chain.getBusinessDescription() != null) {
                generator.writeStringField("businessDescription", chain.getBusinessDescription());
            }
            if (chain.getAssumptions() != null) {
                generator.writeStringField("assumptions", chain.getAssumptions());
            }
            if (chain.getOutOfScope() != null) {
                generator.writeStringField("outOfScope", chain.getOutOfScope());
            }
            if (!CollectionUtils.isEmpty((Collection)(maskedFields = chain.getMaskedFields()))) {
                generator.writeObjectField("maskedFields", (Object)maskedFields);
            }
            if (!CollectionUtils.isEmpty((Collection)chain.getLabels())) {
                generator.writeArrayFieldStart("labels");
                for (ChainLabel label : chain.getLabels().stream().filter(l -> !l.isTechnical()).toList()) {
                    generator.writeString(label.getName());
                }
                generator.writeEndArray();
            }
            if (!CollectionUtils.isEmpty((Collection)chain.getElements())) {
                generator.writeObjectField("elements", chain.getElements().stream().filter(element -> element.getParent() == null).collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty(chainDependencies = this.getDependencies(chain))) {
                generator.writeObjectField("dependencies", chainDependencies);
            }
            if (!CollectionUtils.isEmpty(chainDeployments = this.getChainDeployments(chain))) {
                generator.writeObjectField("deployments", chainDeployments);
                generator.writeObjectField("deployAction", (Object)ChainCommitRequestAction.DEPLOY);
            } else {
                generator.writeObjectField("deployAction", (Object)ChainCommitRequestAction.SNAPSHOT);
            }
            FolderSerializeEntity folder = this.getChainFolder((FoldableEntity)chain);
            if (folder != null) {
                generator.writeObjectField("folder", (Object)folder);
            }
            generator.writeStringField("migrations", ImportFileMigrationUtils.getActualChainFileMigrationVersions().stream().sorted().toList().toString());
            generator.writeEndObject();
        }
        catch (IOException e) {
            log.warn("Exception while serializing Chain {}, exception: ", (Object)chain.getId(), (Object)e);
            throw e;
        }
    }

    private FolderSerializeEntity getChainFolder(FoldableEntity folder) {
        FolderSerializeEntity folderEntity = null;
        while (folder.getParentFolder() != null) {
            folder = folder.getParentFolder();
            folderEntity = new FolderSerializeEntity(folder.getName(), folder.getDescription(), folderEntity);
        }
        return folderEntity;
    }

    private List<DeploymentExternalEntity> getChainDeployments(Chain chain) {
        ArrayList<DeploymentExternalEntity> deploymentsForExport = new ArrayList<DeploymentExternalEntity>();
        chain.getDeployments().forEach(deployment -> deploymentsForExport.add((DeploymentExternalEntity)((DeploymentExternalEntity.DeploymentExternalEntityBuilder)DeploymentExternalEntity.builder().domain(deployment.getDomain())).build()));
        return deploymentsForExport;
    }

    private Set<Dependency> getDependencies(Chain chain) {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        List allChainElement = chain.getElements();
        for (ChainElement element : allChainElement) {
            dependencies.addAll(element.getInputDependencies());
            dependencies.addAll(element.getOutputDependencies());
        }
        return dependencies;
    }
}

