/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.util;

import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EngineDomainUtils {
    private static final String DASH_VERSION_REGEX = "-v\\d+$";
    private final Pattern defaultVersionedDomainPattern;
    @Value(value="${qip.domain.default}")
    private String engineDefaultDomain;

    @Autowired
    public EngineDomainUtils(@Value(value="${qip.internal-services.engine}") String engineNamePrefix) {
        this.defaultVersionedDomainPattern = Pattern.compile("^" + engineNamePrefix + DASH_VERSION_REGEX);
    }

    public String convertKubeDeploymentToDomainName(String deploymentName) {
        boolean isDefault = this.defaultVersionedDomainPattern.matcher(deploymentName).find();
        return isDefault ? this.engineDefaultDomain : deploymentName.replaceFirst(DASH_VERSION_REGEX, "");
    }
}

