/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.model.system.EnvironmentSourceType;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.model.constant.ConnectionSourceType;

public class MaasUtils {
    private static String[] KAFKA_MAAS_PARAM_ARRAY = new String[]{"brokers", "topics", "securityProtocol", "saslMechanism", "saslJaasConfig"};
    public static ArrayList<String> KAFKA_MAAS_PARAM_LIST = new ArrayList<String>(Arrays.asList(KAFKA_MAAS_PARAM_ARRAY));
    private static String[] AMQP_MAAS_PARAM_ARRAY = new String[]{"addresses", "vhost", "username", "password", "sslProtocol"};
    public static ArrayList<String> AMQP_MAAS_PARAM_LIST = new ArrayList<String>(Arrays.asList(AMQP_MAAS_PARAM_ARRAY));

    public static String getMaasParamPlaceholder(String elementId, String paramName) {
        return String.format("%%%%{%s_%s}", elementId, paramName);
    }

    public static ArrayList<String> getMaasParams(ChainElement element) {
        try {
            ServiceEnvironment environment = element.getEnvironment();
            Map elementProperties = element.getProperties();
            if (element.getType() == null) {
                return new ArrayList<String>();
            }
            switch (element.getType()) {
                case "service-call": 
                case "async-api-trigger": {
                    if (environment == null || environment.getSourceType() != EnvironmentSourceType.MAAS_BY_CLASSIFIER || elementProperties.get("integrationOperationProtocolType") == null) break;
                    switch ((String)elementProperties.get("integrationOperationProtocolType")) {
                        case "kafka": {
                            return KAFKA_MAAS_PARAM_LIST;
                        }
                        case "amqp": {
                            return AMQP_MAAS_PARAM_LIST;
                        }
                    }
                    break;
                }
                case "kafka-sender-2": 
                case "kafka-trigger-2": {
                    if (!ConnectionSourceType.MAAS.toString().equalsIgnoreCase((String)elementProperties.get("connectionSourceType"))) break;
                    return KAFKA_MAAS_PARAM_LIST;
                }
                case "rabbitmq-sender-2": 
                case "rabbitmq-trigger-2": {
                    if (!ConnectionSourceType.MAAS.toString().equalsIgnoreCase((String)elementProperties.get("connectionSourceType"))) break;
                    return AMQP_MAAS_PARAM_LIST;
                }
            }
        }
        catch (Exception e) {
            throw new SnapshotCreationException("Failed to get MaaS state.", element, e);
        }
        return new ArrayList<String>();
    }
}

