/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.configuration;

import jakarta.annotation.PostConstruct;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportV2RedirectPathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@AutoConfiguration
@EnableScheduling
@EnableJpaAuditing
@EnableRetry
@EnableAsync
@ComponentScan(basePackages={"org.qubership.integration.platform.catalog.*", "org.qubership.integration.platform.runtime.catalog.*"})
public class ApplicationAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApplicationAutoConfiguration.class);
    private final String cloudServiceName;
    private final ApplicationContext context;
    @Value(value="${qip.gateway.egress.url}")
    private String gatewayUrl;
    @Value(value="${spring.profiles.active}")
    private String activeProfiles;

    @Autowired
    public ApplicationAutoConfiguration(@Value(value="${spring.application.cloud_service_name}") String cloudServiceName, ApplicationContext context) {
        this.cloudServiceName = cloudServiceName;
        this.context = context;
    }

    @PostConstruct
    private void showValues() {
        log.info("GATEWAY_URI: {}", (Object)this.gatewayUrl);
    }

    @Bean
    public DocumentBuilder documentBuilder() {
        try {
            return DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new BeanInitializationException("Can't provide document builder for building xml configurations");
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={ImportV2RedirectPathResolver.class})
    public ImportV2RedirectPathResolver importV2RedirectPathResolver() {
        return (headers, internalPath) -> URI.create(internalPath);
    }

    public String getDeploymentName() {
        return this.cloudServiceName;
    }

    public void closeApplicationWithError() {
        SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 1});
        System.exit(1);
    }

    public String getCloudServiceName() {
        return this.cloudServiceName;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    public String getActiveProfiles() {
        return this.activeProfiles;
    }
}

