/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElementSearchCriteria;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.chain.ChainRolesResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.chain.UpdateRolesRequest;
import org.qubership.integration.platform.runtime.catalog.service.ChainRolesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/chains/roles"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="chain-roles-controller", description="Chain Roles Controller")
public class ChainRolesController {
    private static final Logger log = LoggerFactory.getLogger(ChainRolesController.class);
    private final ChainRolesService chainRolesService;

    @Autowired
    public ChainRolesController(ChainRolesService chainRolesService) {
        this.chainRolesService = chainRolesService;
    }

    @PostMapping(value={""})
    @Operation(description="Get all chains with http trigger roles")
    public ResponseEntity<ChainRolesResponse> findBySearchRequest(@RequestBody @Parameter(description="Search criteria for chain element") ChainElementSearchCriteria request, @RequestParam(required=false, defaultValue="false") @Parameter(description="Whether include only http triggers with selected implemented service") boolean isImplementedOnly) {
        ChainRolesResponse response = this.chainRolesService.findAllChainByHttpTrigger(request, isImplementedOnly);
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={""})
    @Operation(description="Make a bulk update on roles configuration for http triggers")
    public ResponseEntity<ChainRolesResponse> updateRoles(@RequestBody @Parameter(description="Http trigger roles update request object") List<UpdateRolesRequest> request) {
        ChainRolesResponse response = this.chainRolesService.updateRoles(request);
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/redeploy"})
    @Operation(description="Make a bulk redeploy for chains specified in the request")
    public ResponseEntity<ChainRolesResponse> bulkRedeploy(@RequestBody @Parameter(description="Http trigger roles update request object") List<UpdateRolesRequest> request) {
        ChainRolesResponse response = this.chainRolesService.redeploy(request);
        return ResponseEntity.ok((Object)response);
    }
}

