/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.AdditionalPropertiesBuilder;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.AdditionalPropertiesBuilderProvider;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqElementPropertiesBuilder
implements ElementPropertiesBuilder {
    private final Collection<AdditionalPropertiesBuilder> additionalPropertiesBuilders;

    @Autowired
    public RabbitMqElementPropertiesBuilder(AdditionalPropertiesBuilderProvider additionalPropertiesBuilderProvider) {
        this.additionalPropertiesBuilders = additionalPropertiesBuilderProvider.getBuilders(RabbitMqElementPropertiesBuilder.class);
    }

    public boolean applicableTo(ChainElement element) {
        return List.of("rabbitmq", "rabbitmq-sender", "rabbitmq-trigger-2", "rabbitmq-sender-2").contains(element.getType());
    }

    public Map<String, String> build(ChainElement element) {
        Map elementProperties = this.buildAmqpConnectionProperties(element.getPropertyAsString("sslProtocol"), element.getPropertyAsString("addresses"), element.getPropertyAsString("queues"), element.getPropertyAsString("exchange"), element.getPropertyAsString("username"), element.getPropertyAsString("password"), element.getPropertyAsString("connectionSourceType"), element.getPropertyAsString("vhost"));
        this.enrichWithAdditionalProperties(element, elementProperties);
        return elementProperties;
    }

    public Map<String, String> buildAmqpConnectionProperties(String ssl, String address, String queues, String exchange, String username, String password, String sourceType, String vHost) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("sslProtocol", ssl);
        properties.put("addresses", address);
        properties.put("queues", queues);
        properties.put("exchange", exchange);
        properties.put("username", username);
        properties.put("password", password);
        properties.put("connectionSourceType", sourceType);
        properties.put("vhost", vHost);
        properties.put("integrationOperationProtocolType", "amqp");
        return properties;
    }

    public void enrichWithAdditionalProperties(ChainElement element, Map<String, String> elementProperties) {
        this.additionalPropertiesBuilders.forEach(builder -> elementProperties.putAll(builder.build(element)));
    }
}

