/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.persistence.configs.repository.diagnostic.ElementValidationRepository;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationImplementationType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationEntityType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin.BuiltinValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LowHttpTriggerSecurityValidation
extends BuiltinValidation {
    private static final Logger log = LoggerFactory.getLogger(LowHttpTriggerSecurityValidation.class);
    private final ElementValidationRepository elementRepository;

    public LowHttpTriggerSecurityValidation(ElementValidationRepository elementRepository) {
        super("low-http-trigger-security_M7IWPBFF", "Access control settings are not specified for HTTP Triggers", "Rule allows to check if RBAC or ABAC settings are defined under HTTP Triggers.", "To avoid unauthorized access to the chain via HTTP, please consider RBAC or ABAC settings on the HTTP Trigger.", ValidationEntityType.CHAIN_ELEMENT, ValidationImplementationType.BUILT_IN, ValidationSeverity.ERROR);
        this.elementRepository = elementRepository;
    }

    public Collection<ValidationChainAlert> validate() throws DiagnosticValidationUnexpectedException {
        try {
            return this.processValidation();
        }
        catch (Exception e) {
            throw new DiagnosticValidationUnexpectedException("Validation failed with an unexpected error: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private List<ValidationChainAlert> processValidation() {
        List elements = this.elementRepository.findAllForLowChainSecurityValidation();
        return elements.stream().map(element -> ValidationChainAlert.builder().validationId(this.getId()).chain(element.getChain()).element(element).build()).toList();
    }
}

