/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import java.util.LinkedList;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.FolderRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FolderService {
    private final FolderRepository folderRepository;
    private final ActionsLogService actionLogger;
    private final AuditingHandler auditingHandler;

    @Autowired
    public FolderService(FolderRepository folderRepository, ActionsLogService actionLogger, AuditingHandler jpaAuditingHandler) {
        this.folderRepository = folderRepository;
        this.actionLogger = actionLogger;
        this.auditingHandler = jpaAuditingHandler;
    }

    public Folder findFirstByName(String name, Folder parent) {
        return this.folderRepository.findFirstByNameAndParentFolder(name, parent);
    }

    public Folder findEntityByIdOrNull(String folderId) {
        return folderId != null ? (Folder)this.folderRepository.findById((Object)folderId).orElse(null) : null;
    }

    public Folder save(Folder folder, String parentFolderId) {
        this.auditingHandler.markModified((Object)folder);
        return this.upsertFolder(folder, parentFolderId);
    }

    public Folder save(Folder folder, Folder parentFolder) {
        if (parentFolder == null) {
            return this.save(folder, (String)null);
        }
        return this.save(folder, parentFolder.getId());
    }

    private Folder upsertFolder(Folder folder, String parentFolderId) {
        Folder newFolder = (Folder)this.folderRepository.save((Object)folder);
        if (parentFolderId != null) {
            Folder parentFolder = this.findEntityByIdOrNull(parentFolderId);
            parentFolder.addChildFolder(newFolder);
            newFolder = (Folder)this.folderRepository.save((Object)newFolder);
        }
        return newFolder;
    }

    public Folder setActualizedFolderState(Folder folderState) {
        LinkedList<Folder> actualizedFolderList = new LinkedList<Folder>(folderState.getFolderList().stream().map(arg_0 -> ((FolderRepository)this.folderRepository).persist(arg_0)).toList());
        folderState.setFolderList(actualizedFolderList);
        if (folderState.getParentFolder() != null) {
            Folder actualizedParentFolder = this.setActualizedFolderState(folderState.getParentFolder());
            folderState.setParentFolder(actualizedParentFolder);
        }
        return (Folder)this.folderRepository.persist((Object)folderState);
    }
}

