/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.helper.HelperFunction;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;
import org.qubership.integration.platform.runtime.catalog.builder.templates.helpers.BaseHelper;
import org.qubership.integration.platform.runtime.catalog.mapper.MappingDescriptionValidator;
import org.qubership.integration.platform.runtime.catalog.mapper.MappingInterpreter;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.MappingDescription;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@TemplatesHelper
public class MapperInterpretatorHelper
extends BaseHelper {
    private final ObjectMapper objectMapper;
    private final MappingInterpreter interpreter;
    private final MappingDescriptionValidator validator;

    @Autowired
    public MapperInterpretatorHelper(MappingInterpreter interpreter, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, MappingDescriptionValidator validator) {
        this.interpreter = interpreter;
        this.objectMapper = objectMapper;
        this.validator = validator;
    }

    @HelperFunction(value="mapper-interpretation")
    public String apply(String mappingDescriptionAsString, Options options) {
        try {
            MappingDescription mappingDescription = Objects.isNull(mappingDescriptionAsString) ? new MappingDescription(null, null, null, null, null) : (MappingDescription)this.objectMapper.readValue(mappingDescriptionAsString, MappingDescription.class);
            this.validator.validate(mappingDescription);
            return this.interpreter.getInterpretation(mappingDescription);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error processing JSON in property-json helper", e);
        }
        catch (SnapshotCreationException e) {
            Object context = options.context.model();
            if (context instanceof ChainElement) {
                ChainElement element = (ChainElement)context;
                if (Objects.isNull(e.getElementId())) {
                    e.setElementId(Optional.ofNullable(element.getOriginalId()).orElse(element.getId()));
                    e.setElementName(element.getName());
                }
            }
            throw e;
        }
    }

    public CharSequence mappingId(Options options) {
        return UUID.randomUUID().toString();
    }
}

