/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationStatus;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationAlertsSet;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.DiagnosticValidationDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.ValidationChainEntityDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.ValidationStatusDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.DiagnosticValidationMapper;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.AbstractValidation;
import org.springframework.stereotype.Component;

@Component
public class DiagnosticValidationMapperImpl
implements DiagnosticValidationMapper {
    public DiagnosticValidationDTO asDTO(AbstractValidation validation, ValidationStatusDTO status, ValidationAlertsSet alertsSet) {
        if (validation == null && status == null && alertsSet == null) {
            return null;
        }
        DiagnosticValidationDTO.DiagnosticValidationDTOBuilder diagnosticValidationDTO = DiagnosticValidationDTO.builder();
        if (validation != null) {
            diagnosticValidationDTO.id(validation.getId());
            diagnosticValidationDTO.title(validation.getTitle());
            diagnosticValidationDTO.description(validation.getDescription());
            diagnosticValidationDTO.suggestion(validation.getSuggestion());
            diagnosticValidationDTO.entityType(validation.getEntityType());
            diagnosticValidationDTO.implementationType(validation.getImplementationType());
            diagnosticValidationDTO.severity(validation.getSeverity());
            diagnosticValidationDTO.properties(this.stringSerializableMapToStringObjectMap(validation.getProperties()));
        }
        if (alertsSet != null) {
            diagnosticValidationDTO.alertsCount(alertsSet.getAlertsCount());
            diagnosticValidationDTO.chainEntities(this.asChainEntityDTO(alertsSet.getChainAlerts()));
        }
        diagnosticValidationDTO.status(status);
        return diagnosticValidationDTO.build();
    }

    public ValidationStatusDTO asStatusDTO(ValidationStatus currentStatus) {
        if (currentStatus == null) {
            return null;
        }
        ValidationStatusDTO.ValidationStatusDTOBuilder validationStatusDTO = ValidationStatusDTO.builder();
        validationStatusDTO.state(currentStatus.getState());
        validationStatusDTO.startedWhen(currentStatus.getStartedWhen());
        validationStatusDTO.message(currentStatus.getMessage());
        return validationStatusDTO.build();
    }

    public List<ValidationChainEntityDTO> asChainEntityDTO(List<ValidationChainAlert> chainEntities) {
        if (chainEntities == null) {
            return null;
        }
        ArrayList<ValidationChainEntityDTO> list = new ArrayList<ValidationChainEntityDTO>(chainEntities.size());
        for (ValidationChainAlert validationChainAlert : chainEntities) {
            list.add(this.asChainEntityDTO(validationChainAlert));
        }
        return list;
    }

    public ValidationChainEntityDTO asChainEntityDTO(ValidationChainAlert entity) {
        if (entity == null) {
            return null;
        }
        ValidationChainEntityDTO.ValidationChainEntityDTOBuilder validationChainEntityDTO = ValidationChainEntityDTO.builder();
        validationChainEntityDTO.chainId(this.entityChainId(entity));
        validationChainEntityDTO.chainName(this.entityChainName(entity));
        validationChainEntityDTO.elementId(this.entityElementId(entity));
        validationChainEntityDTO.elementName(this.entityElementName(entity));
        validationChainEntityDTO.elementType(this.entityElementType(entity));
        Map map = entity.getProperties();
        if (map != null) {
            validationChainEntityDTO.properties(new LinkedHashMap(map));
        }
        return validationChainEntityDTO.build();
    }

    protected Map<String, Object> stringSerializableMapToStringObjectMap(Map<String, Serializable> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, Serializable> entry : map.entrySet()) {
            String key = entry.getKey();
            Serializable value = entry.getValue();
            map1.put(key, value);
        }
        return map1;
    }

    private String entityChainId(ValidationChainAlert validationChainAlert) {
        if (validationChainAlert == null) {
            return null;
        }
        Chain chain = validationChainAlert.getChain();
        if (chain == null) {
            return null;
        }
        String id = chain.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String entityChainName(ValidationChainAlert validationChainAlert) {
        if (validationChainAlert == null) {
            return null;
        }
        Chain chain = validationChainAlert.getChain();
        if (chain == null) {
            return null;
        }
        String name = chain.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private String entityElementId(ValidationChainAlert validationChainAlert) {
        if (validationChainAlert == null) {
            return null;
        }
        ChainElement element = validationChainAlert.getElement();
        if (element == null) {
            return null;
        }
        String id = element.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String entityElementName(ValidationChainAlert validationChainAlert) {
        if (validationChainAlert == null) {
            return null;
        }
        ChainElement element = validationChainAlert.getElement();
        if (element == null) {
            return null;
        }
        String name = element.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private String entityElementType(ValidationChainAlert validationChainAlert) {
        if (validationChainAlert == null) {
            return null;
        }
        ChainElement element = validationChainAlert.getElement();
        if (element == null) {
            return null;
        }
        String type = element.getType();
        if (type == null) {
            return null;
        }
        return type;
    }
}

