/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.runtime.catalog.events.EngineStateUpdateEvent;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.event.Event;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.event.EventsUpdate;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.event.GenericMessage;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.event.GenericMessageType;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.event.ObjectType;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.DeploymentMapper;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.EngineMapper;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.EngineService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.AuditorAware;
import org.springframework.stereotype.Component;

@Component
public class EventService {
    private static final Logger log = LoggerFactory.getLogger(EventService.class);
    private static final int EVENT_TIME_THRESHOLD_MS = 15000;
    private static final int EVENTS_QUEUE_SIZE = 100;
    private final DeploymentService deploymentService;
    private final EngineService engineService;
    private final DeploymentMapper deploymentMapper;
    private final EngineMapper engineMapper;
    private final AuditorAware<User> auditor;
    private final ReadWriteLock readWriteLock;
    private final CircularFifoQueue<Event> circularFifoQueue;

    @Autowired
    public EventService(DeploymentService deploymentService, EngineService engineService, DeploymentMapper deploymentMapper, EngineMapper engineMapper, AuditorAware<User> auditor) {
        this.deploymentService = deploymentService;
        this.engineService = engineService;
        this.deploymentMapper = deploymentMapper;
        this.engineMapper = engineMapper;
        this.auditor = auditor;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.circularFifoQueue = new CircularFifoQueue(100);
    }

    @EventListener
    public void applicationStartedListener(ApplicationStartedEvent event) {
        try {
            this.subscribeOnEvents();
        }
        catch (Exception e) {
            log.error("Failed to subscribe on events", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventsUpdate getEvents(String lastEventId) {
        ArrayList<Event> result = new ArrayList<Event>();
        long now = new Date().getTime();
        boolean lastEventFound = lastEventId.isBlank();
        String newLastEventId = "";
        Optional user = this.auditor.getCurrentAuditor();
        String userId = null;
        if (user.isPresent()) {
            userId = ((User)user.get()).getId();
        }
        this.readWriteLock.readLock().lock();
        try {
            for (Event event : this.circularFifoQueue) {
                if (lastEventFound) {
                    if (now - event.getTime() >= 15000L || event.getUserId() != null && !event.getUserId().equals(userId)) continue;
                    result.add(event);
                    continue;
                }
                if (!event.getId().equals(lastEventId)) continue;
                lastEventFound = true;
            }
            if (!this.circularFifoQueue.isEmpty()) {
                newLastEventId = ((Event)this.circularFifoQueue.get(this.circularFifoQueue.size() - 1)).getId();
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return EventsUpdate.builder().events(result).lastEventId(newLastEventId).build();
    }

    @EventListener
    public void onEngineStateUpdate(EngineStateUpdateEvent stateUpdateEvent) {
        try {
            EngineDeployment engineDeployment = stateUpdateEvent.getEngineDeployment();
            this.addEvent(UUID.randomUUID().toString(), (Object)this.deploymentMapper.toRuntimeUpdate(engineDeployment, stateUpdateEvent.getEngineInfo(), stateUpdateEvent.getLoggingInfo()), ObjectType.DEPLOYMENT, stateUpdateEvent.getUserId());
        }
        catch (Exception e) {
            log.warn("Failed to add engine update state event: {}", (Object)e.getMessage());
        }
    }

    private void subscribeOnEvents() {
        this.deploymentService.subscribeMessages((arg_0, arg_1, arg_2, arg_3, arg_4) -> this.addMessageEvent(arg_0, arg_1, arg_2, arg_3, arg_4));
        this.engineService.subscribeEngines((id, pod, domain, actionType, userId) -> this.addEvent(UUID.randomUUID().toString(), (Object)this.engineMapper.asEngineUpdate(pod, domain, actionType), ObjectType.ENGINE, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageEvent(String id, String userId, String message, GenericMessageType type, Map<String, String> optionalFields) {
        this.readWriteLock.writeLock().lock();
        try {
            this.circularFifoQueue.add((Object)Event.builder().id(id).userId(userId).time(new Date().getTime()).objectType(ObjectType.GENERIC_MESSAGE).data((Object)GenericMessage.builder().message(message).type(type).optionalFields(optionalFields).build()).build());
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(String id, Object data, ObjectType type, String userId) {
        this.readWriteLock.writeLock().lock();
        try {
            this.circularFifoQueue.add((Object)Event.builder().id(id).userId(userId).time(new Date().getTime()).data(data).objectType(type).build());
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

