/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions;

import java.util.Optional;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ApiSpecificationExportException;

public class ChainElementVerificationException
extends ApiSpecificationExportException {
    private final String chainId;
    private final String elementId;

    public ChainElementVerificationException(ChainElement element, String message) {
        super(ChainElementVerificationException.buildMessage(element, message));
        this.chainId = ChainElementVerificationException.extractChainId(element);
        this.elementId = ChainElementVerificationException.extractElementId(element);
    }

    private static String buildMessage(ChainElement element, String message) {
        return String.format("Chain ID: %s, element ID: %s. %s", ChainElementVerificationException.extractChainId(element), ChainElementVerificationException.extractElementId(element), message);
    }

    protected static String extractChainId(ChainElement element) {
        return Optional.ofNullable(element).map(ChainElement::getChain).map(AbstractEntity::getId).orElse(null);
    }

    protected static String extractElementId(ChainElement element) {
        return Optional.ofNullable(element).map(AbstractEntity::getId).orElse(null);
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getElementId() {
        return this.elementId;
    }
}

