/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationImplementationType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationEntityType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin.BuiltinValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeprecatedElementUsageValidation
extends BuiltinValidation {
    private static final Logger log = LoggerFactory.getLogger(DeprecatedElementUsageValidation.class);
    private final ElementRepository elementRepository;
    private final LibraryElementsService libraryElementsService;

    @Autowired
    public DeprecatedElementUsageValidation(ElementRepository elementRepository, LibraryElementsService libraryElementsService) {
        super("deprecated-element_YLTU14X8", "Deprecated elements found in the chain", "Rule allows to find chains with deprecated elements.", "Chain contains deprecated elements. Please consider automatic migration option, available on the configuration graph, or manually re-configure the chain.", ValidationEntityType.CHAIN_ELEMENT, ValidationImplementationType.BUILT_IN, ValidationSeverity.ERROR);
        this.elementRepository = elementRepository;
        this.libraryElementsService = libraryElementsService;
    }

    public Collection<ValidationChainAlert> validate() throws DiagnosticValidationUnexpectedException {
        try {
            return this.processValidation();
        }
        catch (Exception e) {
            throw new DiagnosticValidationUnexpectedException("Validation failed with an unexpected error: " + e.getMessage(), e);
        }
    }

    @NotNull
    private List<ValidationChainAlert> processValidation() {
        List deprecatedTypes = this.libraryElementsService.getDeprecatedElementsNames();
        List deprecatedElements = this.elementRepository.findAllByTypeInAndChainNotNull((Collection)deprecatedTypes);
        return deprecatedElements.stream().map(element -> ValidationChainAlert.builder().validationId(this.getId()).chain(element.getChain()).element(element).build()).toList();
    }
}

