/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.verification.properties.verifiers;

import java.util.Collection;
import java.util.List;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.ElementPropertiesVerifier;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.VerificationError;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.verifiers.MaasElementPropertiesVerifierHelper;
import org.springframework.stereotype.Component;

@Component
public class KafkaElementPropertiesVerifier
implements ElementPropertiesVerifier {
    @Override
    public boolean applicableTo(ChainElement element) {
        return List.of("kafka", "kafka-sender", "kafka-trigger-2", "kafka-sender-2").contains(element.getType());
    }

    @Override
    public Collection<VerificationError> verify(ChainElement element) {
        String sourceType = element.getPropertyAsString("connectionSourceType");
        String maasClassifier = element.getPropertyAsString("topicsClassifierName");
        return MaasElementPropertiesVerifierHelper.verifyMaasProperties(sourceType, maasClassifier);
    }
}

