/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.ElementProperty;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;
import org.qubership.integration.platform.runtime.catalog.builder.templates.helpers.BaseHelper;
import org.qubership.integration.platform.runtime.catalog.util.MaasUtils;
import org.springframework.beans.factory.annotation.Autowired;

@TemplatesHelper(value="query")
public class QueryParamsHelper
extends BaseHelper
implements Helper<ChainElement> {
    private final LibraryElementsService libraryElementsService;

    @Autowired
    public QueryParamsHelper(LibraryElementsService libraryElementsService) {
        this.libraryElementsService = libraryElementsService;
    }

    public Object apply(ChainElement element, Options options) throws IOException {
        ElementDescriptor descriptor = this.libraryElementsService.getElementDescriptor(element);
        StringBuilder str = new StringBuilder();
        List queryProperties = descriptor.getQueryProperties();
        ArrayList maasEnabledParams = MaasUtils.getMaasParams((ChainElement)element);
        for (ElementProperty property : queryProperties) {
            String value = this.getPropertyValue(element, property);
            if (!maasEnabledParams.isEmpty() && maasEnabledParams.contains(property.getName())) {
                value = MaasUtils.getMaasParamPlaceholder((String)element.getOriginalId(), (String)property.getName());
                this.setPropertyValue(str, property, value);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            this.setPropertyValue(str, property, value);
        }
        return str.toString();
    }

    private String getPropertyValue(ChainElement element, ElementProperty property) {
        String value = element.getPropertyAsString(property.getName());
        if (property.isMultiple()) {
            value = Optional.ofNullable(element.getProperty(property.getName())).filter(Collection.class::isInstance).map(values -> ((Collection)values).stream().map(String::valueOf).collect(Collectors.joining(","))).orElse(value);
        }
        return value;
    }

    private void setPropertyValue(StringBuilder str, ElementProperty property, String value) {
        if (str.length() == 0) {
            str.append("?");
        } else {
            str.append("&");
        }
        str.append(property.getName()).append("=").append(value);
    }
}

