/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.bulk.BulkDeploymentRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.bulk.BulkDeploymentResponse;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/chains/deployments"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="bulk-deployment-controller", description="Bulk Deployment Controller")
public class BulkDeploymentController {
    private static final Logger log = LoggerFactory.getLogger(BulkDeploymentController.class);
    private final DeploymentService deploymentService;

    @Autowired
    public BulkDeploymentController(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @PostMapping(value={"/bulk"})
    @Operation(description="(Re)deploy chains in bulk mode")
    public ResponseEntity<List<BulkDeploymentResponse>> bulkCreate(@RequestBody @Valid @Parameter(description="Chain bulk deploy request object") BulkDeploymentRequest request) {
        log.info("Request to bulk redeploy chains");
        Pair bulkDeploymentResponses = this.deploymentService.bulkCreate(request);
        return (Boolean)bulkDeploymentResponses.getLeft() != false ? ResponseEntity.status((HttpStatusCode)HttpStatus.MULTI_STATUS).body((Object)((List)bulkDeploymentResponses.getRight())) : ResponseEntity.ok((Object)((List)bulkDeploymentResponses.getRight()));
    }
}

