/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.SnapshotLabel;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.snapshot.SnapshotLabelDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.snapshot.SnapshotRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.snapshot.SnapshotResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.SnapshotMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SnapshotMapperImpl
implements SnapshotMapper {
    @Autowired
    private UserMapper userMapper;

    public SnapshotResponse asResponse(Snapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        SnapshotResponse.SnapshotResponseBuilder snapshotResponse = SnapshotResponse.builder();
        snapshotResponse.id(snapshot.getId());
        snapshotResponse.name(snapshot.getName());
        snapshotResponse.description(snapshot.getDescription());
        snapshotResponse.createdWhen(MapperUtils.fromTimestamp((Timestamp)snapshot.getCreatedWhen()));
        snapshotResponse.createdBy(this.userMapper.asDTO(snapshot.getCreatedBy()));
        snapshotResponse.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)snapshot.getModifiedWhen()));
        snapshotResponse.modifiedBy(this.userMapper.asDTO(snapshot.getModifiedBy()));
        snapshotResponse.xmlDefinition(snapshot.getXmlDefinition());
        snapshotResponse.labels(this.snapshotLabelSetToSnapshotLabelDTOList(snapshot.getLabels()));
        return snapshotResponse.build();
    }

    public List<SnapshotResponse> asResponse(List<Snapshot> snapshots) {
        if (snapshots == null) {
            return null;
        }
        ArrayList<SnapshotResponse> list = new ArrayList<SnapshotResponse>(snapshots.size());
        for (Snapshot snapshot : snapshots) {
            list.add(this.asResponse(snapshot));
        }
        return list;
    }

    public Snapshot asRequest(SnapshotRequest snapshot) {
        if (snapshot == null) {
            return null;
        }
        Snapshot.SnapshotBuilder snapshot1 = Snapshot.builder();
        snapshot1.name(snapshot.getName());
        snapshot1.labels(this.snapshotLabelDTOListToSnapshotLabelSet(snapshot.getLabels()));
        return snapshot1.build();
    }

    public SnapshotLabel asLabelRequest(SnapshotLabelDTO snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        SnapshotLabel.SnapshotLabelBuilder snapshotLabel1 = SnapshotLabel.builder();
        snapshotLabel1.name(snapshotLabel.getName());
        if (snapshotLabel.getTechnical() != null) {
            snapshotLabel1.technical(snapshotLabel.getTechnical().booleanValue());
        }
        return snapshotLabel1.build();
    }

    public List<SnapshotLabel> asLabelRequests(List<SnapshotLabelDTO> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<SnapshotLabel> list = new ArrayList<SnapshotLabel>(snapshotLabel.size());
        for (SnapshotLabelDTO snapshotLabelDTO : snapshotLabel) {
            list.add(this.asLabelRequest(snapshotLabelDTO));
        }
        return list;
    }

    public SnapshotLabelDTO asLabelResponse(SnapshotLabel snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        SnapshotLabelDTO.SnapshotLabelDTOBuilder snapshotLabelDTO = SnapshotLabelDTO.builder();
        snapshotLabelDTO.name(snapshotLabel.getName());
        snapshotLabelDTO.technical(Boolean.valueOf(snapshotLabel.isTechnical()));
        return snapshotLabelDTO.build();
    }

    public List<SnapshotLabelDTO> asLabelResponse(List<SnapshotLabel> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<SnapshotLabelDTO> list = new ArrayList<SnapshotLabelDTO>(snapshotLabel.size());
        for (SnapshotLabel snapshotLabel1 : snapshotLabel) {
            list.add(this.asLabelResponse(snapshotLabel1));
        }
        return list;
    }

    protected List<SnapshotLabelDTO> snapshotLabelSetToSnapshotLabelDTOList(Set<SnapshotLabel> set) {
        if (set == null) {
            return null;
        }
        ArrayList<SnapshotLabelDTO> list = new ArrayList<SnapshotLabelDTO>(set.size());
        for (SnapshotLabel snapshotLabel : set) {
            list.add(this.asLabelResponse(snapshotLabel));
        }
        return list;
    }

    protected Set<SnapshotLabel> snapshotLabelDTOListToSnapshotLabelSet(List<SnapshotLabelDTO> list) {
        if (list == null) {
            return null;
        }
        LinkedHashSet<SnapshotLabel> set = new LinkedHashSet<SnapshotLabel>(Math.max((int)((float)list.size() / 0.75f) + 1, 16));
        for (SnapshotLabelDTO snapshotLabelDTO : list) {
            set.add(this.asLabelRequest(snapshotLabelDTO));
        }
        return set;
    }
}

